/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.DingerDefinition;
import com.github.jaemon.dinger.core.DingerDefinitionGenerator;
import com.github.jaemon.dinger.core.DingerDefinitionGeneratorContext;
import com.github.jaemon.dinger.core.DingerDefinitionGeneratorFactory;
import com.github.jaemon.dinger.core.DingerDefinitionResolver;
import com.github.jaemon.dinger.core.DingerParameterNameDiscoverer;
import com.github.jaemon.dinger.core.annatations.AsyncExecute;
import com.github.jaemon.dinger.core.annatations.DingerConfiguration;
import com.github.jaemon.dinger.core.entity.DingerMethod;
import com.github.jaemon.dinger.core.entity.enums.DingerDefinitionType;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.listeners.DingerListenersProperty;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterNameDiscoverer;

public abstract class AbstractDingerDefinitionResolver<T>
extends DingerListenersProperty
implements DingerDefinitionResolver<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDingerDefinitionResolver.class);
    private Map<String, Class<? extends DingerDefinitionGenerator>> dingerDefinitionGeneratorMap = new HashMap<String, Class<? extends DingerDefinitionGenerator>>();
    protected ParameterNameDiscoverer parameterNameDiscoverer = new DingerParameterNameDiscoverer();

    public AbstractDingerDefinitionResolver() {
        for (DingerDefinitionType dingerDefinitionType : DingerDefinitionType.dingerDefinitionTypes) {
            this.dingerDefinitionGeneratorMap.put((Object)((Object)dingerDefinitionType.dingerType()) + "." + (Object)((Object)dingerDefinitionType.messageMainType()) + "." + (Object)((Object)dingerDefinitionType.messageSubType()), dingerDefinitionType.dingerDefinitionGenerator());
        }
    }

    protected DingerConfig dingerConfiguration(Class<?> dingerClass) {
        DingerConfiguration dingerConfiguration;
        String tokenId;
        DingerConfig dingerConfig = new DingerConfig();
        if (dingerClass.isAnnotationPresent(DingerConfiguration.class) && DingerUtils.isNotEmpty(tokenId = (dingerConfiguration = dingerClass.getAnnotation(DingerConfiguration.class)).tokenId())) {
            dingerConfig.setTokenId(tokenId);
            dingerConfig.setDecryptKey(dingerConfiguration.decryptKey());
            dingerConfig.setSecret(dingerConfiguration.secret());
        }
        if (dingerClass.isAnnotationPresent(AsyncExecute.class)) {
            dingerConfig.setAsyncExecute(true);
        }
        return dingerConfig;
    }

    void registerDingerDefinition(String dingerName, Object source, String dingerDefinitionKey, DingerConfig dingerConfiguration, DingerMethod dingerMethod) {
        boolean debugEnabled = log.isDebugEnabled();
        for (DingerType dingerType : enabledDingerTypes) {
            DingerConfig defaultDingerConfig = (DingerConfig)defaultDingerConfigs.get((Object)dingerType);
            if (dingerConfiguration == null) {
                if (!debugEnabled) continue;
                log.debug("dinger={} not open and skip the corresponding dinger registration.", (Object)dingerType);
                continue;
            }
            String keyName = (Object)((Object)dingerType) + "." + dingerName;
            String key = (Object)((Object)dingerType) + "." + dingerDefinitionKey;
            Class<? extends DingerDefinitionGenerator> dingerDefinitionGeneratorClass = this.dingerDefinitionGeneratorMap.get(key);
            if (dingerDefinitionGeneratorClass == null) {
                if (!debugEnabled) continue;
                log.debug("\u5f53\u524dkey=%s\u5728DingerDefinitionType\u4e2d\u6ca1\u5b9a\u4e49", (Object)key);
                continue;
            }
            DingerDefinitionGenerator dingerDefinitionGenerator = DingerDefinitionGeneratorFactory.get(dingerDefinitionGeneratorClass.getName());
            DingerDefinition dingerDefinition = dingerDefinitionGenerator.generator(new DingerDefinitionGeneratorContext<Object>(keyName, source));
            if (dingerDefinition == null) {
                if (!debugEnabled) continue;
                log.debug("keyName={} dinger[{}] format is illegal.", (Object)keyName, (Object)dingerDefinitionKey);
                continue;
            }
            if (Container.INSTANCE.contains(keyName)) {
                throw new DingerException(ExceptionEnum.DINGER_REPEATED_EXCEPTION, keyName);
            }
            if (dingerMethod.check()) {
                throw new DingerException(ExceptionEnum.METHOD_DEFINITION_EXCEPTION, dingerMethod.getMethodName());
            }
            dingerDefinition.setMethodParams(dingerMethod.getMethodParams());
            dingerDefinition.setGenericIndex(dingerMethod.getParamTypes());
            dingerDefinition.dingerConfig().merge(dingerConfiguration).merge(defaultDingerConfig);
            Container.INSTANCE.put(keyName, dingerDefinition);
            if (!debugEnabled) continue;
            log.debug("dinger definition={} has been registed.", (Object)keyName);
        }
    }

    protected static void clear() {
        Container.INSTANCE.container.clear();
    }

    protected static enum Container {
        INSTANCE;

        private Map<String, DingerDefinition> container = new HashMap<String, DingerDefinition>(128);

        DingerDefinition get(String key) {
            return this.container.get(key);
        }

        void put(String key, DingerDefinition dingerDefinition) {
            this.container.put(key, dingerDefinition);
        }

        boolean contains(String key) {
            return this.container.containsKey(key);
        }
    }
}

