/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import com.github.ansell.shp.SHPUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.csv.CSVDataStore;
import org.geotools.data.csv.CSVDataStoreFactory;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.jooq.lambda.Unchecked;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class CSV2SHP {
    public static void main(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec input = parser.accepts("input").withRequiredArg().ofType(File.class).required().describedAs("The input CSV file");
        ArgumentAcceptingOptionSpec output = parser.accepts("output").withRequiredArg().ofType(File.class).required().describedAs("The output directory to use for the resulting file");
        ArgumentAcceptingOptionSpec outputPrefix = parser.accepts("prefix").withRequiredArg().ofType(String.class).required().describedAs("The output prefix to use for the shapefiles created");
        ArgumentAcceptingOptionSpec wktFieldOption = parser.accepts("wkt-field").withRequiredArg().ofType(String.class).defaultsTo((Object)"the_geom", (Object[])new String[0]).describedAs("The field containing the WKT");
        ArgumentAcceptingOptionSpec removeIfEmpty = parser.accepts("remove-if-empty").withRequiredArg().ofType(String.class).describedAs("The name of an attribute to remove if its value is empty before outputting the resulting shapefile. Use multiple times to specify multiple fields to check");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException e2) {
            System.out.println(e2.getMessage());
            parser.printHelpOn((OutputStream)System.out);
            throw e2;
        }
        if (options.has((OptionSpec)help)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path inputPath = ((File)input.value(options)).toPath();
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find input SHP file: " + inputPath.toString());
        }
        Path outputPath = ((File)output.value(options)).toPath();
        if (!Files.exists(outputPath, new LinkOption[0])) {
            throw new FileNotFoundException("Output directory does not exist: " + outputPath.toString());
        }
        String prefix = (String)outputPrefix.value(options);
        String wktField = (String)wktFieldOption.value(options);
        ConcurrentHashMap.KeySetView filterFields = ConcurrentHashMap.newKeySet();
        if (options.has((OptionSpec)removeIfEmpty)) {
            for (String nextFilterField : removeIfEmpty.values(options)) {
                System.out.println("Will filter field if empty value found: " + nextFilterField);
                filterFields.add(nextFilterField);
            }
        }
        if (!filterFields.isEmpty()) {
            System.out.println("Full set of filter fields: " + filterFields);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("strategy", "wkt");
        params.put("wktField", wktField);
        params.put("file", inputPath.toFile());
        CSVDataStoreFactory csvDataStoreFactory = new CSVDataStoreFactory();
        CSVDataStore store = (CSVDataStore)csvDataStoreFactory.createDataStore(params);
        if (store == null) {
            throw new RuntimeException("Could not read the given input at: " + inputPath.toAbsolutePath().toString());
        }
        CSVStrategy csvStrategy = store.getCSVStrategy();
        for (String typeName : new LinkedHashSet<String>(Arrays.asList(store.getTypeNames()))) {
            System.out.println("");
            System.out.println("Type: " + typeName);
            ContentFeatureSource featureSource = store.getFeatureSource(typeName);
            SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
            NameImpl outputSchemaName = new NameImpl(schema.getName().getNamespaceURI(), schema.getName().getLocalPart().replace(" ", "").replace("%20", ""));
            System.out.println("Replacing name on schema: " + schema.getName() + " with " + outputSchemaName);
            SimpleFeatureTypeImpl outputSchema = SHPUtils.changeSchemaName(schema, (Name)outputSchemaName);
            ArrayList<String> attributeList = new ArrayList<String>();
            for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                System.out.println("Attribute: " + attribute.getName().toString());
                attributeList.add(attribute.getName().toString());
            }
            List longFieldsList = attributeList.stream().filter(nextAtt -> nextAtt.length() > 10).collect(Collectors.toList());
            if (!longFieldsList.isEmpty()) {
                throw new RuntimeException("Shapefile contained field names longer than 10 characters, and is hence invalid: " + longFieldsList.toString());
            }
            if (attributeList.size() > 255) {
                throw new RuntimeException("Shapefile contained more than 255 fields and hence is invalid and possibly corrupted: " + attributeList.size());
            }
            SimpleFeatureCollection collection = featureSource.getFeatures();
            int featureCount = 0;
            CopyOnWriteArrayList<SimpleFeature> outputFeatureList = new CopyOnWriteArrayList<SimpleFeature>();
            try (SimpleFeatureIterator iterator = collection.features();){
                ArrayList<String> nextLine = new ArrayList<String>();
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    if (++featureCount <= 2) {
                        System.out.println("");
                        System.out.println(feature.getIdentifier());
                    } else if (featureCount % 100 == 0) {
                        System.out.print(".");
                    }
                    boolean filterThisFeature = false;
                    for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                        String featureString = Optional.ofNullable(feature.getAttribute(attribute.getName())).orElse("").toString();
                        nextLine.add(featureString);
                        if (filterFields.contains(attribute.getName().toString()) && featureString.trim().isEmpty()) {
                            filterThisFeature = true;
                        }
                        if (featureString.length() > 100) {
                            featureString = featureString.substring(0, 100) + "...";
                        }
                        if (featureCount > 2) continue;
                        System.out.print(attribute.getName() + "=");
                        System.out.println(featureString);
                    }
                    if (!filterThisFeature) {
                        outputFeatureList.add(SHPUtils.changeSchemaName(feature, (SimpleFeatureType)outputSchema));
                    }
                    nextLine.clear();
                }
            }
            if (featureCount > 100) {
                System.out.println("");
            }
            System.out.println("");
            System.out.println("Feature count: " + featureCount);
            ListFeatureCollection outputCollection = new ListFeatureCollection((SimpleFeatureType)outputSchema, outputFeatureList);
            Path outputShapefilePath = outputPath.resolve(prefix + "-" + outputSchema.getTypeName() + "-dump");
            if (!Files.exists(outputShapefilePath, new LinkOption[0])) {
                Files.createDirectory(outputShapefilePath, new FileAttribute[0]);
            }
            SHPUtils.writeShapefile((SimpleFeatureCollection)outputCollection, outputShapefilePath);
            Path outputShapefileZipPath = outputPath.resolve(prefix + "-" + outputSchema.getTypeName() + "-dump.zip");
            OutputStream out = Files.newOutputStream(outputShapefileZipPath, StandardOpenOption.CREATE_NEW);
            Throwable throwable = null;
            try {
                ZipOutputStream zip = new ZipOutputStream(out, StandardCharsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    Files.list(outputShapefilePath).forEachOrdered(Unchecked.consumer(e -> {
                        zip.putNextEntry(new ZipEntry(e.getFileName().toString()));
                        Files.copy(e, zip);
                        zip.closeEntry();
                    }));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (zip == null) continue;
                    if (throwable2 != null) {
                        try {
                            zip.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    zip.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                out.close();
            }
        }
    }
}

