/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.geotools.data.shapefile.ShapefileDumper;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class SHPUtils {
    public static void renderImage(MapContent map, OutputStream output, int imageWidth, String format) throws IOException {
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        ReferencedEnvelope mapBounds = map.getMaxBounds();
        double heightToWidth = mapBounds.getSpan(1) / mapBounds.getSpan(0);
        Rectangle imageBounds = new Rectangle(0, 0, imageWidth, (int)Math.round((double)imageWidth * heightToWidth));
        BufferedImage image = new BufferedImage(imageBounds.width, imageBounds.height, 1);
        Graphics2D gr = image.createGraphics();
        gr.setPaint(Color.WHITE);
        gr.fill(imageBounds);
        renderer.paint(gr, imageBounds, mapBounds);
        ImageIO.write((RenderedImage)image, format, output);
    }

    public static void writeShapefile(SimpleFeatureCollection fc, Path outputDir) throws IOException {
        ShapefileDumper dumper = new ShapefileDumper(outputDir.toFile());
        dumper.setCharset(StandardCharsets.UTF_8);
        int maxSize = 1048576000;
        dumper.setMaxDbfSize((long)maxSize);
        dumper.dump(fc);
    }

    public static SimpleFeatureTypeImpl cloneSchema(SimpleFeatureType schema) {
        return SHPUtils.changeSchemaName(schema, schema.getName());
    }

    public static SimpleFeatureTypeImpl changeSchemaName(SimpleFeatureType schema, Name outputSchemaName) {
        return new SimpleFeatureTypeImpl(outputSchemaName, schema.getAttributeDescriptors(), schema.getGeometryDescriptor(), schema.isAbstract(), schema.getRestrictions(), schema.getSuper(), schema.getDescription());
    }

    public static SimpleFeature changeSchemaName(SimpleFeature feature, SimpleFeatureType outputSchema) {
        return new SimpleFeatureImpl(feature.getAttributes(), outputSchema, feature.getIdentifier());
    }
}

