/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.filepicker.utils;

import com.github.angads25.filepicker.model.DialogProperties;
import java.io.File;
import java.io.FileFilter;
import java.util.Locale;

public class ExtensionFilter
implements FileFilter {
    private final String[] validExtensions;
    private DialogProperties properties;

    public ExtensionFilter(DialogProperties properties) {
        this.validExtensions = properties.extensions != null ? properties.extensions : new String[]{""};
        this.properties = properties;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory() && file.canRead()) {
            return true;
        }
        if (this.properties.selection_type == 1) {
            return false;
        }
        String name = file.getName().toLowerCase(Locale.getDefault());
        for (String ext : this.validExtensions) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }
}

