/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.note;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.github.anastr.speedviewlib.components.note.Note;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0014R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/anastr/speedviewlib/components/note/ImageNote;", "Lcom/github/anastr/speedviewlib/components/note/Note;", "context", "Landroid/content/Context;", "resource", "", "(Landroid/content/Context;I)V", "width", "height", "(Landroid/content/Context;III)V", "image", "Landroid/graphics/Bitmap;", "(Landroid/content/Context;Landroid/graphics/Bitmap;II)V", "imageRect", "Landroid/graphics/RectF;", "notePaint", "Landroid/graphics/Paint;", "build", "", "viewWidth", "drawContains", "canvas", "Landroid/graphics/Canvas;", "leftX", "", "topY", "speedviewlib_release"})
public final class ImageNote
extends Note<ImageNote> {
    @NotNull
    private final Bitmap image;
    private final int width;
    private final int height;
    @NotNull
    private final RectF imageRect;
    @NotNull
    private final Paint notePaint;

    @JvmOverloads
    public ImageNote(@NotNull Context context, @NotNull Bitmap image, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(context);
        this.image = image;
        this.width = width;
        this.height = height;
        this.imageRect = new RectF();
        this.notePaint = new Paint(1);
        boolean bl = this.width > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "width must be bigger than 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.height > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "height must be bigger than 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ImageNote(Context context, Bitmap bitmap, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = bitmap.getWidth();
        }
        if ((n3 & 8) != 0) {
            n2 = bitmap.getHeight();
        }
        this(context, bitmap, n, n2);
    }

    public ImageNote(@NotNull Context context, int resource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resource);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeResource(context.resources, resource)");
        this(context, bitmap, 0, 0, 12, null);
    }

    public ImageNote(@NotNull Context context, int resource, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resource);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeResource(context.resources, resource)");
        this(context, bitmap, width, height);
    }

    @Override
    public void build(int viewWidth) {
        this.noticeContainsSizeChange(this.width, this.height);
    }

    @Override
    protected void drawContains(@NotNull Canvas canvas, float leftX, float topY) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.imageRect.set(leftX, topY, leftX + (float)this.width, topY + (float)this.height);
        canvas.drawBitmap(this.image, null, this.imageRect, this.notePaint);
    }

    @JvmOverloads
    public ImageNote(@NotNull Context context, @NotNull Bitmap image, int width) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this(context, image, width, 0, 8, null);
    }

    @JvmOverloads
    public ImageNote(@NotNull Context context, @NotNull Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this(context, image, 0, 0, 12, null);
    }
}

