/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/NeedleIndicator;", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bottomY", "", "circlePaint", "Landroid/graphics/Paint;", "circlePath", "Landroid/graphics/Path;", "indicatorPath", "draw", "", "canvas", "Landroid/graphics/Canvas;", "degree", "getBottom", "setWithEffects", "withEffects", "", "updateIndicator", "speedviewlib_release"})
public final class NeedleIndicator
extends Indicator<NeedleIndicator> {
    @NotNull
    private final Path indicatorPath;
    @NotNull
    private final Path circlePath;
    @NotNull
    private final Paint circlePaint;
    private float bottomY;

    public NeedleIndicator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.indicatorPath = new Path();
        this.circlePath = new Path();
        this.circlePaint = new Paint(1);
        this.setWidth(this.dpTOpx(12.0f));
        this.circlePaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public float getBottom() {
        return this.bottomY;
    }

    @Override
    public void draw(@NotNull Canvas canvas, float degree) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.getIndicatorPaint());
        canvas.drawPath(this.circlePath, this.circlePaint);
        canvas.restore();
    }

    @Override
    public void updateIndicator() {
        this.indicatorPath.reset();
        this.circlePath.reset();
        float f = this.getCenterX();
        Speedometer speedometer = this.getSpeedometer();
        Intrinsics.checkNotNull((Object)speedometer);
        this.indicatorPath.moveTo(f, (float)speedometer.getPadding());
        double d = Math.toRadians(260.0);
        boolean bl = false;
        float f2 = (float)((double)this.getWidth() * Math.sin(d)) + this.getViewSize() * 0.5f;
        Speedometer speedometer2 = this.getSpeedometer();
        Intrinsics.checkNotNull((Object)speedometer2);
        this.bottomY = f2 + (float)speedometer2.getPadding();
        double d2 = Math.toRadians(260.0);
        boolean bl2 = false;
        float f3 = (float)((double)this.getWidth() * Math.cos(d2)) + this.getViewSize() * 0.5f;
        Speedometer speedometer3 = this.getSpeedometer();
        Intrinsics.checkNotNull((Object)speedometer3);
        float xLeft = f3 + (float)speedometer3.getPadding();
        this.indicatorPath.lineTo(xLeft, this.bottomY);
        RectF rectF = new RectF(this.getCenterX() - this.getWidth(), this.getCenterY() - this.getWidth(), this.getCenterX() + this.getWidth(), this.getCenterY() + this.getWidth());
        this.indicatorPath.arcTo(rectF, 260.0f, 20.0f);
        float circleWidth = this.getWidth() * 0.25f;
        this.circlePath.addCircle(this.getCenterX(), this.getCenterY(), this.getWidth() - circleWidth * 0.5f + 0.6f, Path.Direction.CW);
        this.getIndicatorPaint().setColor(this.getColor());
        this.circlePaint.setColor(this.getColor());
        this.circlePaint.setStrokeWidth(circleWidth);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects) {
            Speedometer speedometer = this.getSpeedometer();
            Intrinsics.checkNotNull((Object)speedometer);
            if (!speedometer.isInEditMode()) {
                this.getIndicatorPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
                return;
            }
        }
        this.getIndicatorPaint().setMaskFilter(null);
    }
}

