/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0014J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u0018\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0007J\b\u0010\u001c\u001a\u00020\fH\u0014R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/github/anastr/speedviewlib/ImageSpeedometer;", "Lcom/github/anastr/speedviewlib/Speedometer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "imageSpeedometer", "Landroid/graphics/drawable/Drawable;", "defaultGaugeValues", "", "defaultSpeedometerValues", "getImageSpeedometer", "initAttributeSet", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "setImageSpeedometer", "bitmapImage", "Landroid/graphics/Bitmap;", "imageResource", "updateBackgroundBitmap", "speedviewlib_release"})
public class ImageSpeedometer
extends Speedometer {
    @Nullable
    private Drawable imageSpeedometer;

    @JvmOverloads
    public ImageSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ ImageSpeedometer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    protected void defaultSpeedometerValues() {
        this.setBackgroundCircleColor(0);
    }

    @Override
    protected void defaultGaugeValues() {
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ImageSpeedometer, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.ImageSpeedometer, 0, 0)");
        TypedArray a = typedArray;
        this.imageSpeedometer = a.getDrawable(R.styleable.ImageSpeedometer_sv_image);
        a.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateBackgroundBitmap();
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        if (this.imageSpeedometer != null) {
            Drawable drawable = this.imageSpeedometer;
            Intrinsics.checkNotNull((Object)drawable);
            drawable.setBounds((int)this.getViewLeft() + this.getPadding(), (int)this.getViewTop() + this.getPadding(), (int)this.getViewRight() - this.getPadding(), (int)this.getViewBottom() - this.getPadding());
            Drawable drawable2 = this.imageSpeedometer;
            Intrinsics.checkNotNull((Object)drawable2);
            drawable2.draw(c);
        }
        this.drawMarks(c);
        this.drawTicks(c);
    }

    @Nullable
    public final Drawable getImageSpeedometer() {
        return this.imageSpeedometer;
    }

    public final void setImageSpeedometer(int imageResource) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setImageSpeedometer(this.getContext().getDrawable(imageResource));
        } else {
            this.setImageSpeedometer(this.getContext().getResources().getDrawable(imageResource));
        }
    }

    public final void setImageSpeedometer(@Nullable Drawable imageSpeedometer) {
        this.imageSpeedometer = imageSpeedometer;
        this.updateBackgroundBitmap();
    }

    public final void setImageSpeedometer(@NotNull Bitmap bitmapImage) {
        Intrinsics.checkNotNullParameter((Object)bitmapImage, (String)"bitmapImage");
        this.setImageSpeedometer((Drawable)new BitmapDrawable(this.getContext().getResources(), bitmapImage));
    }

    @JvmOverloads
    public ImageSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ImageSpeedometer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

