/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.Gauge;
import com.github.anastr.speedviewlib.LinearGauge;
import com.github.anastr.speedviewlib.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0014J\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0014J\b\u0010\u0012\u001a\u00020\rH\u0014R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/anastr/speedviewlib/ImageLinearGauge;", "Lcom/github/anastr/speedviewlib/LinearGauge;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backColor", "image", "Landroid/graphics/drawable/Drawable;", "defaultGaugeValues", "", "initAttributeSet", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "updateFrontAndBackBitmaps", "speedviewlib_release"})
public class ImageLinearGauge
extends LinearGauge {
    @Nullable
    private Drawable image;
    private int backColor;

    @JvmOverloads
    public ImageLinearGauge(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.backColor = -2697257;
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ ImageLinearGauge(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    protected void defaultGaugeValues() {
        super.setSpeedTextPosition(Gauge.Position.CENTER);
        super.setUnitUnderSpeedText(true);
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ImageLinearGauge, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.ImageLinearGauge, 0, 0)");
        TypedArray a = typedArray;
        this.backColor = a.getColor(R.styleable.ImageLinearGauge_sv_speedometerBackColor, this.backColor);
        this.image = a.getDrawable(R.styleable.ImageLinearGauge_sv_image);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int h;
        int w;
        block6: {
            block5: {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                w = this.getMeasuredWidth();
                h = this.getMeasuredHeight();
                if (this.image == null || w == 0 || h == 0) break block5;
                Drawable drawable = this.image;
                Intrinsics.checkNotNull((Object)drawable);
                if (drawable.getIntrinsicWidth() <= 0) break block5;
                Drawable drawable2 = this.image;
                Intrinsics.checkNotNull((Object)drawable2);
                if (drawable2.getIntrinsicHeight() > 0) break block6;
            }
            return;
        }
        Drawable drawable = this.image;
        Intrinsics.checkNotNull((Object)drawable);
        float imageW = drawable.getIntrinsicWidth();
        Drawable drawable3 = this.image;
        Intrinsics.checkNotNull((Object)drawable3);
        float imageH = drawable3.getIntrinsicHeight();
        float view_w_to_h = w / h;
        float image_w_to_h = imageW / imageH;
        if (image_w_to_h > view_w_to_h) {
            this.setMeasuredDimension(w, (int)((float)w * imageH / imageW));
        } else {
            this.setMeasuredDimension((int)((float)h * imageW / imageH), h);
        }
    }

    @Override
    protected void updateFrontAndBackBitmaps() {
        Canvas canvasBack = this.createBackgroundBitmapCanvas();
        Canvas canvasFront = this.createForegroundBitmapCanvas();
        if (this.image != null) {
            Drawable drawable = this.image;
            Intrinsics.checkNotNull((Object)drawable);
            drawable.setBounds(this.getPadding(), this.getPadding(), this.getWidth() - this.getPadding(), this.getHeight() - this.getPadding());
            Drawable drawable2 = this.image;
            Intrinsics.checkNotNull((Object)drawable2);
            drawable2.setColorFilter(this.backColor, PorterDuff.Mode.SRC_IN);
            Drawable drawable3 = this.image;
            Intrinsics.checkNotNull((Object)drawable3);
            drawable3.draw(canvasBack);
            Drawable drawable4 = this.image;
            Intrinsics.checkNotNull((Object)drawable4);
            drawable4.setColorFilter(null);
            Drawable drawable5 = this.image;
            Intrinsics.checkNotNull((Object)drawable5);
            drawable5.draw(canvasFront);
        }
    }

    @JvmOverloads
    public ImageLinearGauge(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ImageLinearGauge(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

