/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.Gauge;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import com.github.anastr.speedviewlib.components.indicators.TriangleIndicator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0014J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0004J\u0006\u0010$\u001a\u00020\u0007J\b\u0010%\u001a\u00020\u001fH\u0002J\u001a\u0010&\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010'\u001a\u00020\u001fH\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020#H\u0014J(\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0014J\u000e\u0010/\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u0007J\b\u00100\u001a\u00020\u001fH\u0014J\b\u00101\u001a\u00020\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/github/anastr/speedviewlib/AwesomeSpeedometer;", "Lcom/github/anastr/speedviewlib/Speedometer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "customMarkPaint", "Landroid/graphics/Paint;", "markPath", "Landroid/graphics/Path;", "ringPaint", "speedometerColor", "speedometerRect", "Landroid/graphics/RectF;", "speedometerWidth", "", "getSpeedometerWidth", "()F", "setSpeedometerWidth", "(F)V", "trianglesColor", "getTrianglesColor", "()I", "setTrianglesColor", "(I)V", "trianglesPaint", "trianglesPath", "defaultGaugeValues", "", "defaultSpeedometerValues", "drawCustomMarks", "c", "Landroid/graphics/Canvas;", "getSpeedometerColor", "init", "initAttributeSet", "initDraw", "onDraw", "canvas", "onSizeChanged", "w", "h", "oldW", "oldH", "setSpeedometerColor", "updateBackgroundBitmap", "updateGradient", "speedviewlib_release"})
public class AwesomeSpeedometer
extends Speedometer {
    @NotNull
    private final Path markPath;
    @NotNull
    private final Path trianglesPath;
    @NotNull
    private final Paint customMarkPaint;
    @NotNull
    private final Paint ringPaint;
    @NotNull
    private final Paint trianglesPaint;
    @NotNull
    private final RectF speedometerRect;
    private int speedometerColor;

    @JvmOverloads
    public AwesomeSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.markPath = new Path();
        this.trianglesPath = new Path();
        this.customMarkPaint = new Paint(1);
        this.ringPaint = new Paint(1);
        this.trianglesPaint = new Paint(1);
        this.speedometerRect = new RectF();
        this.speedometerColor = -16718106;
        this.init();
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ AwesomeSpeedometer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getTrianglesColor() {
        return this.trianglesPaint.getColor();
    }

    public final void setTrianglesColor(int trianglesColor) {
        this.trianglesPaint.setColor(trianglesColor);
        this.invalidateGauge();
    }

    @Override
    public float getSpeedometerWidth() {
        return super.getSpeedometerWidth();
    }

    @Override
    public void setSpeedometerWidth(float speedometerWidth2) {
        super.setSpeedometerWidth(speedometerWidth2);
        if (this.speedometerRect != null) {
            float risk = speedometerWidth2 * 0.5f;
            this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
            this.updateGradient();
            this.invalidateGauge();
        }
    }

    @Override
    protected void defaultGaugeValues() {
        super.setSpeedometerWidth(this.dpTOpx(60.0f));
        super.setTextColor(-15776);
        super.setSpeedTextColor(-1);
        super.setUnitTextColor(-1);
        super.setTextTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        super.setSpeedTextPosition(Gauge.Position.CENTER);
        super.setUnitUnderSpeedText(true);
    }

    @Override
    protected void defaultSpeedometerValues() {
        Object object = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context");
        this.setIndicator(new TriangleIndicator((Context)object));
        object = this.getIndicator();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$defaultSpeedometerValues_u24lambda_u2d0 = object;
        boolean bl3 = false;
        ((Indicator)$this$defaultSpeedometerValues_u24lambda_u2d0).setWidth(((Indicator)$this$defaultSpeedometerValues_u24lambda_u2d0).dpTOpx(25.0f));
        ((Indicator)$this$defaultSpeedometerValues_u24lambda_u2d0).setColor(-16718106);
        super.setStartEndDegree(135, 455);
        super.setBackgroundCircleColor(-14606047);
        super.setTickNumber(9);
        super.setTickPadding(0);
    }

    private final void init() {
        this.customMarkPaint.setStyle(Paint.Style.STROKE);
        this.getTextPaint().setTextAlign(Paint.Align.CENTER);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.trianglesPaint.setColor(-13022805);
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AwesomeSpeedometer, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.AwesomeSpeedometer, 0, 0)");
        TypedArray a = typedArray;
        this.speedometerColor = a.getColor(R.styleable.AwesomeSpeedometer_sv_speedometerColor, this.speedometerColor);
        this.trianglesPaint.setColor(a.getColor(R.styleable.AwesomeSpeedometer_sv_trianglesColor, this.trianglesPaint.getColor()));
        a.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateGradient();
        this.updateBackgroundBitmap();
    }

    private final void updateGradient() {
        float stop = ((float)this.getSizePa() * 0.5f - this.getSpeedometerWidth()) / ((float)this.getSizePa() * 0.5f);
        float stop2 = stop + (1.0f - stop) * 0.1f;
        float stop3 = stop + (1.0f - stop) * 0.36f;
        float stop4 = stop + (1.0f - stop) * 0.64f;
        float stop5 = stop + (1.0f - stop) * 0.9f;
        int[] nArray = new int[]{this.getBackgroundCircleColor(), this.speedometerColor, this.getBackgroundCircleColor(), this.getBackgroundCircleColor(), this.speedometerColor, this.speedometerColor};
        int[] colors = nArray;
        float[] fArray = new float[]{stop, stop2, stop3, stop4, stop5, 1.0f};
        RadialGradient radialGradient = new RadialGradient((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, (float)this.getSizePa() * 0.5f, colors, fArray, Shader.TileMode.CLAMP);
        this.ringPaint.setShader((Shader)radialGradient);
    }

    private final void initDraw() {
        this.ringPaint.setStrokeWidth(this.getSpeedometerWidth());
        this.customMarkPaint.setColor(this.getMarkColor());
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        this.initDraw();
        float markH = (float)this.getViewSizePa() / 22.0f;
        this.markPath.reset();
        this.markPath.moveTo((float)this.getSize() * 0.5f, (float)this.getPadding());
        this.markPath.lineTo((float)this.getSize() * 0.5f, markH + (float)this.getPadding());
        this.customMarkPaint.setStrokeWidth(markH / 5.0f);
        float triangleHeight = (float)this.getViewSizePa() / 20.0f;
        this.setInitTickPadding(triangleHeight);
        this.trianglesPath.reset();
        this.trianglesPath.moveTo((float)this.getSize() * 0.5f, (float)this.getPadding() + (float)this.getViewSizePa() / 20.0f);
        float triangleWidth = (float)this.getViewSize() / 20.0f;
        this.trianglesPath.lineTo((float)this.getSize() * 0.5f - triangleWidth / 2.0f, (float)this.getPadding());
        this.trianglesPath.lineTo((float)this.getSize() * 0.5f + triangleWidth / 2.0f, (float)this.getPadding());
        float risk = this.getSpeedometerWidth() * 0.5f + (float)this.getPadding();
        this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
        c.drawArc(this.speedometerRect, 0.0f, 360.0f, false, this.ringPaint);
        this.drawCustomMarks(c);
        this.drawMarks(c);
        this.drawTicks(c);
    }

    /*
     * WARNING - void declaration
     */
    protected final void drawCustomMarks(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int range = this.getEndDegree() - this.getStartDegree();
        Iterable $this$forEachIndexed$iv = this.getTicks();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void t;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)item$iv).floatValue();
            int index = n;
            boolean bl2 = false;
            float d = (float)this.getStartDegree() + (float)range * t;
            c.save();
            c.rotate(d + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
            c.drawPath(this.trianglesPath, this.trianglesPaint);
            if (index + 1 != this.getTickNumber()) {
                c.save();
                float f2 = this.getStartDegree();
                float f3 = range;
                Float f4 = this.getTicks().get(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)f4, (String)"ticks[index + 1]");
                float d2 = f2 + f3 * ((Number)f4).floatValue();
                float eachDegree = d2 - d;
                int n2 = 1;
                do {
                    int j = n2++;
                    c.rotate(eachDegree * 0.1f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
                    if (j == 5) {
                        this.customMarkPaint.setStrokeWidth((float)this.getSize() / 22.0f / 5.0f);
                    } else {
                        this.customMarkPaint.setStrokeWidth((float)this.getSize() / 22.0f / 9.0f);
                    }
                    c.drawPath(this.markPath, this.customMarkPaint);
                } while (n2 <= 9);
                c.restore();
            }
            c.restore();
        }
    }

    public final int getSpeedometerColor() {
        return this.speedometerColor;
    }

    public final void setSpeedometerColor(int speedometerColor) {
        this.speedometerColor = speedometerColor;
        this.updateGradient();
        this.invalidateGauge();
    }

    @JvmOverloads
    public AwesomeSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AwesomeSpeedometer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

