/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.Shader;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/TriangleIndicator;", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "indicatorPath", "Landroid/graphics/Path;", "indicatorTop", "", "draw", "", "canvas", "Landroid/graphics/Canvas;", "degree", "getBottom", "getTop", "setWithEffects", "withEffects", "", "updateIndicator", "speedviewlib_release"})
public final class TriangleIndicator
extends Indicator<TriangleIndicator> {
    private Path indicatorPath;
    private float indicatorTop;

    @Override
    public float getTop() {
        return this.indicatorTop;
    }

    @Override
    public float getBottom() {
        return this.indicatorTop + this.getWidth();
    }

    @Override
    public void draw(@NotNull Canvas canvas, float degree) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.getIndicatorPaint());
        canvas.restore();
    }

    @Override
    public void updateIndicator() {
        this.indicatorPath = new Path();
        Speedometer speedometer = this.getSpeedometer();
        if (speedometer == null) {
            Intrinsics.throwNpe();
        }
        float f = speedometer.getPadding();
        Speedometer speedometer2 = this.getSpeedometer();
        if (speedometer2 == null) {
            Intrinsics.throwNpe();
        }
        this.indicatorTop = f + speedometer2.getSpeedometerWidth() + this.dpTOpx(5.0f);
        this.indicatorPath.moveTo(this.getCenterX(), this.indicatorTop);
        this.indicatorPath.lineTo(this.getCenterX() - this.getWidth(), this.indicatorTop + this.getWidth());
        this.indicatorPath.lineTo(this.getCenterX() + this.getWidth(), this.indicatorTop + this.getWidth());
        this.indicatorPath.moveTo(0.0f, 0.0f);
        int endColor = Color.argb((int)0, (int)Color.red((int)this.getColor()), (int)Color.green((int)this.getColor()), (int)Color.blue((int)this.getColor()));
        LinearGradient linearGradient = new LinearGradient(this.getCenterX(), this.indicatorTop, this.getCenterX(), this.indicatorTop + this.getWidth(), this.getColor(), endColor, Shader.TileMode.CLAMP);
        this.getIndicatorPaint().setShader((Shader)linearGradient);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects) {
            Speedometer speedometer = this.getSpeedometer();
            if (speedometer == null) {
                Intrinsics.throwNpe();
            }
            if (!speedometer.isInEditMode()) {
                this.getIndicatorPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
                return;
            }
        }
        this.getIndicatorPaint().setMaskFilter((MaskFilter)null);
    }

    public TriangleIndicator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.indicatorPath = new Path();
        this.setWidth(this.dpTOpx(25.0f));
    }
}

