/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.text.Layout;
import android.text.StaticLayout;
import android.util.AttributeSet;
import android.view.View;
import com.github.anastr.speedviewlib.Gauge;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer$WhenMappings;
import com.github.anastr.speedviewlib.components.Style;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import com.github.anastr.speedviewlib.components.indicators.NoIndicator;
import com.github.anastr.speedviewlib.components.note.Note;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0002\u00a5\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010|\u001a\u00020}2\n\u0010~\u001a\u0006\u0012\u0002\b\u00030J2\t\b\u0002\u0010\u007f\u001a\u00030\u0080\u0001J\t\u0010\u0081\u0001\u001a\u00020}H\u0002J\t\u0010\u0082\u0001\u001a\u00020}H\u0002J\n\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0014J\t\u0010\u0085\u0001\u001a\u00020}H$J\u0013\u0010\u0086\u0001\u001a\u00020}2\b\u0010\u0087\u0001\u001a\u00030\u0084\u0001H\u0004J\u0013\u0010\u0088\u0001\u001a\u00020}2\b\u0010\u0089\u0001\u001a\u00030\u0084\u0001H\u0004J\u0013\u0010\u008a\u0001\u001a\u00020}2\b\u0010\u0089\u0001\u001a\u00030\u0084\u0001H\u0004J\u0013\u0010\u008b\u0001\u001a\u00020}2\b\u0010\u0089\u0001\u001a\u00030\u0084\u0001H\u0004J\u0013\u0010\u008c\u0001\u001a\u00020}2\b\u0010\u0089\u0001\u001a\u00030\u0084\u0001H\u0004J\u0013\u0010\u008d\u0001\u001a\u00020}2\b\u0010\u0087\u0001\u001a\u00030\u0084\u0001H\u0004J\u0012\u0010\u008e\u0001\u001a\u00020\u00122\u0007\u0010\u008f\u0001\u001a\u00020\u0012H\u0004J\t\u0010\u0090\u0001\u001a\u00020\u0007H\u0004J\u0011\u0010\u0091\u0001\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0004J\t\u0010\u0092\u0001\u001a\u00020\u0007H\u0004J\t\u0010\u0093\u0001\u001a\u00020}H\u0002J\u001b\u0010\u0094\u0001\u001a\u00020}2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\t\u0010\u0095\u0001\u001a\u00020}H\u0002J\u0013\u0010\u0096\u0001\u001a\u00020}2\b\u0010\u0089\u0001\u001a\u00030\u0084\u0001H\u0014J\u001b\u0010\u0097\u0001\u001a\u00020}2\u0007\u0010\u0098\u0001\u001a\u00020\u00072\u0007\u0010\u0099\u0001\u001a\u00020\u0007H\u0014J-\u0010\u009a\u0001\u001a\u00020}2\u0007\u0010\u009b\u0001\u001a\u00020\u00072\u0007\u0010\u009c\u0001\u001a\u00020\u00072\u0007\u0010\u009d\u0001\u001a\u00020\u00072\u0007\u0010\u009e\u0001\u001a\u00020\u0007H\u0014J\u0007\u0010\u009f\u0001\u001a\u00020}J\u000f\u0010\u00a0\u0001\u001a\u00020}2\u0006\u0010\u0016\u001a\u00020\u0007J\u0011\u0010\u001b\u001a\u00020}2\u0007\u0010\u0017\u001a\u00030\u00a1\u0001H\u0016J\u000f\u0010\u00a2\u0001\u001a\u00020}2\u0006\u0010d\u001a\u00020\u0007J\u0017\u0010\u00a3\u0001\u001a\u00020}2\u0006\u0010d\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J\t\u0010\u00a4\u0001\u001a\u00020}H\u0002R$\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000b\"\u0004\b\u001f\u0010\rR\u000e\u0010 \u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010$R$\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010(\"\u0004\b,\u0010*R\u000e\u0010-\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u000b\"\u0004\b0\u0010\rR$\u00101\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0015\"\u0004\b3\u0010$R\u0014\u00104\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00109\u001a\u00020:2\u0006\u00109\u001a\u00020:8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R$\u0010?\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010\u0015\"\u0004\bA\u0010$R$\u0010B\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u000b\"\u0004\bD\u0010\rR$\u0010E\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0015\"\u0004\bG\u0010$R\u0018\u0010H\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030J0IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0098\u0001\u0010K\u001a<\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bM\u0012\b\bN\u0012\u0004\b\b(O\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\bM\u0012\b\bN\u0012\u0004\b\b(P\u0012\u0006\u0012\u0004\u0018\u00010Q\u0018\u00010Lj\u0004\u0018\u0001`R2@\u0010K\u001a<\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bM\u0012\b\bN\u0012\u0004\b\b(O\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\bM\u0012\b\bN\u0012\u0004\b\b(P\u0012\u0006\u0012\u0004\u0018\u00010Q\u0018\u00010Lj\u0004\u0018\u0001`R@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u0011\u0010W\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u000bR\u0011\u0010Y\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\u000bR$\u0010[\u001a\u00020\\2\u0006\u0010[\u001a\u00020\\@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R$\u0010a\u001a\u00020\u00122\u0006\u0010a\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bb\u0010\u0015\"\u0004\bc\u0010$R\u000e\u0010d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010e\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bf\u0010\u000b\"\u0004\bg\u0010\rR$\u0010h\u001a\u00020\u00072\u0006\u0010h\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010\u000b\"\u0004\bj\u0010\rR\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00120I2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00120I@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u0014\u0010p\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bq\u0010\u0015R\u0014\u0010r\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bs\u0010\u0015R\u0014\u0010t\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bu\u0010\u0015R\u0014\u0010v\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bw\u0010\u0015R\u0014\u0010x\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010\u0015R\u0014\u0010z\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b{\u0010\u0015\u00a8\u0006\u00a6\u0001"}, d2={"Lcom/github/anastr/speedviewlib/Speedometer;", "Lcom/github/anastr/speedviewlib/Gauge;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backgroundCircleColor", "getBackgroundCircleColor", "()I", "setBackgroundCircleColor", "(I)V", "circleBackPaint", "Landroid/graphics/Paint;", "cutPadding", "<set-?>", "", "degree", "getDegree", "()F", "endDegree", "indicator", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "getIndicator", "()Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "setIndicator", "(Lcom/github/anastr/speedviewlib/components/indicators/Indicator;)V", "indicatorLightColor", "getIndicatorLightColor", "setIndicatorLightColor", "indicatorLightPaint", "initTickPadding", "getInitTickPadding", "setInitTickPadding", "(F)V", "tickRotation", "", "isTickRotation", "()Z", "setTickRotation", "(Z)V", "isWithIndicatorLight", "setWithIndicatorLight", "lastPercentSpeed", "markColor", "getMarkColor", "setMarkColor", "markHeight", "getMarkHeight", "setMarkHeight", "markPaint", "getMarkPaint", "()Landroid/graphics/Paint;", "markPath", "Landroid/graphics/Path;", "markStyle", "Lcom/github/anastr/speedviewlib/components/Style;", "getMarkStyle", "()Lcom/github/anastr/speedviewlib/components/Style;", "setMarkStyle", "(Lcom/github/anastr/speedviewlib/components/Style;)V", "markWidth", "getMarkWidth", "setMarkWidth", "marksNumber", "getMarksNumber", "setMarksNumber", "marksPadding", "getMarksPadding", "setMarksPadding", "notes", "Ljava/util/ArrayList;", "Lcom/github/anastr/speedviewlib/components/note/Note;", "onPrintTickLabel", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "tickPosition", "tick", "", "Lcom/github/anastr/speedviewlib/util/OnPrintTickLabelListener;", "getOnPrintTickLabel", "()Lkotlin/jvm/functions/Function2;", "setOnPrintTickLabel", "(Lkotlin/jvm/functions/Function2;)V", "size", "getSize", "sizePa", "getSizePa", "speedometerMode", "Lcom/github/anastr/speedviewlib/Speedometer$Mode;", "getSpeedometerMode", "()Lcom/github/anastr/speedviewlib/Speedometer$Mode;", "setSpeedometerMode", "(Lcom/github/anastr/speedviewlib/Speedometer$Mode;)V", "speedometerWidth", "getSpeedometerWidth", "setSpeedometerWidth", "startDegree", "tickNumber", "getTickNumber", "setTickNumber", "tickPadding", "getTickPadding", "setTickPadding", "ticks", "getTicks", "()Ljava/util/ArrayList;", "setTicks", "(Ljava/util/ArrayList;)V", "viewBottom", "getViewBottom", "viewCenterX", "getViewCenterX", "viewCenterY", "getViewCenterY", "viewLeft", "getViewLeft", "viewRight", "getViewRight", "viewTop", "getViewTop", "addNote", "", "note", "showTimeMillisecond", "", "checkStartAndEndDegree", "checkTicks", "createBackgroundBitmapCanvas", "Landroid/graphics/Canvas;", "defaultSpeedometerValues", "drawDefMinMaxSpeedPosition", "c", "drawIndicator", "canvas", "drawIndicatorLight", "drawMarks", "drawNotes", "drawTicks", "getDegreeAtSpeed", "speed", "getEndDegree", "getSpeedAtDegree", "getStartDegree", "init", "initAttributeSet", "initAttributeValue", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldW", "oldH", "removeAllNotes", "setEndDegree", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Indicators;", "setStartDegree", "setStartEndDegree", "updateTranslated", "Mode", "speedviewlib_release"})
public abstract class Speedometer
extends Gauge {
    @NotNull
    private Indicator<?> indicator;
    private boolean isWithIndicatorLight;
    private int indicatorLightColor;
    private final Paint circleBackPaint;
    private final Paint indicatorLightPaint;
    @NotNull
    private final Paint markPaint;
    private final Path markPath;
    private int marksNumber;
    private float marksPadding;
    private float markHeight;
    private int backgroundCircleColor;
    private int startDegree;
    private int endDegree;
    private float degree;
    private final ArrayList<Note<?>> notes;
    @NotNull
    private Mode speedometerMode;
    private int cutPadding;
    @NotNull
    private ArrayList<Float> ticks;
    private boolean tickRotation;
    private float initTickPadding;
    private int tickPadding;
    @Nullable
    private Function2<? super Integer, ? super Float, ? extends CharSequence> onPrintTickLabel;
    private float lastPercentSpeed;

    @NotNull
    public final Indicator<?> getIndicator() {
        return this.indicator;
    }

    public final void setIndicator(@NotNull Indicator<?> indicator) {
        Intrinsics.checkParameterIsNotNull(indicator, (String)"indicator");
        this.indicator.deleteObservers();
        indicator.setTargetSpeedometer(this);
        this.indicator = indicator;
        if (this.isAttachedToWindow()) {
            this.indicator.setTargetSpeedometer(this);
            this.invalidate();
        }
    }

    public final boolean isWithIndicatorLight() {
        return this.isWithIndicatorLight;
    }

    public final void setWithIndicatorLight(boolean bl) {
        this.isWithIndicatorLight = bl;
    }

    public final int getIndicatorLightColor() {
        return this.indicatorLightColor;
    }

    public final void setIndicatorLightColor(int n) {
        this.indicatorLightColor = n;
    }

    @NotNull
    protected final Paint getMarkPaint() {
        return this.markPaint;
    }

    @Override
    public float getSpeedometerWidth() {
        return super.getSpeedometerWidth();
    }

    @Override
    public void setSpeedometerWidth(float speedometerWidth2) {
        super.setSpeedometerWidth(speedometerWidth2);
        if (this.isAttachedToWindow()) {
            this.indicator.updateIndicator();
        }
    }

    public final int getMarksNumber() {
        return this.marksNumber;
    }

    public final void setMarksNumber(int marksNumber) {
        this.marksNumber = marksNumber;
        this.invalidateGauge();
    }

    public final int getMarkColor() {
        return this.markPaint.getColor();
    }

    public final void setMarkColor(int markColor) {
        this.markPaint.setColor(markColor);
    }

    public final float getMarksPadding() {
        return this.marksPadding;
    }

    public final void setMarksPadding(float marksPadding) {
        this.marksPadding = marksPadding;
        this.invalidateGauge();
    }

    public final float getMarkHeight() {
        return this.markHeight;
    }

    public final void setMarkHeight(float markHeight) {
        this.markHeight = markHeight;
        this.invalidateGauge();
    }

    public final float getMarkWidth() {
        return this.markPaint.getStrokeWidth();
    }

    public final void setMarkWidth(float markWidth) {
        this.markPaint.setStrokeWidth(markWidth);
        this.invalidateGauge();
    }

    @NotNull
    public final Style getMarkStyle() {
        return this.markPaint.getStrokeCap() == Paint.Cap.ROUND ? Style.ROUND : Style.BUTT;
    }

    public final void setMarkStyle(@NotNull Style markStyle) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)markStyle), (String)"markStyle");
        if (markStyle == Style.ROUND) {
            this.markPaint.setStrokeCap(Paint.Cap.ROUND);
        } else {
            this.markPaint.setStrokeCap(Paint.Cap.BUTT);
        }
        this.invalidateGauge();
    }

    public final int getBackgroundCircleColor() {
        return this.backgroundCircleColor;
    }

    public final void setBackgroundCircleColor(int backgroundCircleColor) {
        this.backgroundCircleColor = backgroundCircleColor;
        this.circleBackPaint.setColor(backgroundCircleColor);
        this.invalidateGauge();
    }

    protected final float getDegree() {
        return this.degree;
    }

    @NotNull
    public final Mode getSpeedometerMode() {
        return this.speedometerMode;
    }

    public final void setSpeedometerMode(@NotNull Mode speedometerMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)speedometerMode), (String)"speedometerMode");
        this.speedometerMode = speedometerMode;
        if (speedometerMode != Mode.NORMAL) {
            this.startDegree = speedometerMode.getMinDegree$speedviewlib_release();
            this.endDegree = speedometerMode.getMaxDegree$speedviewlib_release();
        }
        this.updateTranslated();
        this.cancelSpeedAnimator();
        this.degree = this.getDegreeAtSpeed(this.getSpeed());
        this.indicator.updateIndicator();
        if (this.isAttachedToWindow()) {
            this.requestLayout();
            this.invalidateGauge();
            this.tremble();
        }
    }

    @NotNull
    public final ArrayList<Float> getTicks() {
        return this.ticks;
    }

    public final void setTicks(@NotNull ArrayList<Float> ticks) {
        Intrinsics.checkParameterIsNotNull(ticks, (String)"ticks");
        this.ticks.clear();
        this.ticks.addAll((Collection<Float>)ticks);
        this.checkTicks();
        this.invalidateGauge();
    }

    protected final float getInitTickPadding() {
        return this.initTickPadding;
    }

    protected final void setInitTickPadding(float f) {
        this.initTickPadding = f;
    }

    public final int getTickPadding() {
        return this.tickPadding;
    }

    public final void setTickPadding(int tickPadding) {
        this.tickPadding = tickPadding;
        this.invalidateGauge();
    }

    @Nullable
    public final Function2<Integer, Float, CharSequence> getOnPrintTickLabel() {
        return this.onPrintTickLabel;
    }

    public final void setOnPrintTickLabel(@Nullable Function2<? super Integer, ? super Float, ? extends CharSequence> onPrintTickLabel) {
        this.onPrintTickLabel = onPrintTickLabel;
        this.invalidateGauge();
    }

    public final int getSize() {
        int n;
        if (this.speedometerMode == Mode.NORMAL) {
            return this.getWidth();
        }
        if (this.speedometerMode.isHalf()) {
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            boolean bl = false;
            n = Math.max(n2, n3);
        } else {
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            boolean bl = false;
            n = Math.max(n4, n5) * 2 - this.cutPadding * 2;
        }
        return n;
    }

    public final int getSizePa() {
        return this.getSize() - this.getPadding() * 2;
    }

    public final int getTickNumber() {
        return this.ticks.size();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTickNumber(int tickNumber) {
        boolean bl = tickNumber >= 0;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "tickNumber mustn't be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ArrayList<Float> ticks = new ArrayList<Float>();
        float tickEach = tickNumber == 1 ? 0.0f : 1.0f / (float)(tickNumber - 1);
        n = 0;
        int n2 = tickNumber;
        while (n < n2) {
            void i;
            ticks.add(Float.valueOf(tickEach * (float)i));
            ++i;
        }
        this.setTicks(ticks);
    }

    public final boolean isTickRotation() {
        return this.tickRotation;
    }

    public final void setTickRotation(boolean tickRotation) {
        this.tickRotation = tickRotation;
        this.invalidateGauge();
    }

    protected final float getViewCenterX() {
        float f;
        switch (Speedometer$WhenMappings.$EnumSwitchMapping$0[this.speedometerMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                f = (float)this.getSize() * 0.5f - (float)this.getWidth() * 0.5f;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                f = (float)this.getSize() * 0.5f + (float)this.getWidth() * 0.5f;
                break;
            }
            default: {
                f = (float)this.getSize() * 0.5f;
            }
        }
        return f;
    }

    protected final float getViewCenterY() {
        float f;
        switch (Speedometer$WhenMappings.$EnumSwitchMapping$1[this.speedometerMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                f = (float)this.getSize() * 0.5f - (float)this.getHeight() * 0.5f;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                f = (float)this.getSize() * 0.5f + (float)this.getHeight() * 0.5f;
                break;
            }
            default: {
                f = (float)this.getSize() * 0.5f;
            }
        }
        return f;
    }

    protected final float getViewLeft() {
        return this.getViewCenterX() - (float)this.getWidth() * 0.5f;
    }

    protected final float getViewTop() {
        return this.getViewCenterY() - (float)this.getHeight() * 0.5f;
    }

    protected final float getViewRight() {
        return this.getViewCenterX() + (float)this.getWidth() * 0.5f;
    }

    protected final float getViewBottom() {
        return this.getViewCenterY() + (float)this.getHeight() * 0.5f;
    }

    private final void init() {
        this.indicatorLightPaint.setStyle(Paint.Style.STROKE);
        this.markPaint.setStyle(Paint.Style.STROKE);
        this.setMarkColor((int)0xFFFFFFFFL);
        this.setMarkWidth(this.dpTOpx(3.0f));
        this.setMarkStyle(Style.BUTT);
        this.defaultSpeedometerValues();
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        int ind;
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Speedometer, 0, 0);
        int mode = a.getInt(R.styleable.Speedometer_sv_speedometerMode, -1);
        if (mode != -1 && mode != 0) {
            this.setSpeedometerMode(Mode.values()[mode]);
        }
        if ((ind = a.getInt(R.styleable.Speedometer_sv_indicator, -1)) != -1) {
            this.setIndicator(Indicator.Indicators.values()[ind]);
        }
        this.setMarksNumber(a.getInt(R.styleable.Speedometer_sv_marksNumber, this.marksNumber));
        this.setMarksPadding(a.getDimension(R.styleable.Speedometer_sv_marksPadding, this.marksPadding));
        this.setMarkHeight(a.getDimension(R.styleable.Speedometer_sv_markHeight, this.markHeight));
        this.setMarkWidth(a.getDimension(R.styleable.Speedometer_sv_markWidth, this.getMarkWidth()));
        this.setMarkColor(a.getColor(R.styleable.Speedometer_sv_markColor, this.getMarkColor()));
        int markStyleIndex = a.getInt(R.styleable.Speedometer_sv_markStyle, -1);
        if (markStyleIndex != -1) {
            this.setMarkStyle(Style.values()[markStyleIndex]);
        }
        this.setBackgroundCircleColor(a.getColor(R.styleable.Speedometer_sv_backgroundCircleColor, this.backgroundCircleColor));
        this.startDegree = a.getInt(R.styleable.Speedometer_sv_startDegree, this.startDegree);
        this.endDegree = a.getInt(R.styleable.Speedometer_sv_endDegree, this.endDegree);
        this.indicator.setWidth(a.getDimension(R.styleable.Speedometer_sv_indicatorWidth, this.indicator.getWidth()));
        this.cutPadding = (int)a.getDimension(R.styleable.Speedometer_sv_cutPadding, (float)this.cutPadding);
        this.setTickNumber(a.getInteger(R.styleable.Speedometer_sv_tickNumber, this.ticks.size()));
        this.tickRotation = a.getBoolean(R.styleable.Speedometer_sv_tickRotation, this.tickRotation);
        this.setTickPadding((int)a.getDimension(R.styleable.Speedometer_sv_tickPadding, (float)this.tickPadding));
        this.indicator.setColor(a.getColor(R.styleable.Speedometer_sv_indicatorColor, this.indicator.getColor()));
        this.isWithIndicatorLight = a.getBoolean(R.styleable.Speedometer_sv_withIndicatorLight, this.isWithIndicatorLight);
        this.indicatorLightColor = a.getColor(R.styleable.Speedometer_sv_indicatorLightColor, this.indicatorLightColor);
        int tickFormat = a.getInt(R.styleable.Speedometer_sv_tickTextFormat, -1);
        if (tickFormat == 0) {
            this.setOnPrintTickLabel((Function2<? super Integer, ? super Float, ? extends CharSequence>)((Function2)new Function2<Integer, Float, String>(this){
                final /* synthetic */ Speedometer this$0;

                @NotNull
                public final String invoke(int $noName_0, float speed) {
                    String string = "%.0f";
                    Locale locale = this.this$0.getLocale();
                    Object[] objectArray = new Object[]{Float.valueOf(speed)};
                    boolean bl = false;
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
                    return string2;
                }
                {
                    this.this$0 = speedometer;
                    super(2);
                }
            }));
        } else if (tickFormat == 1) {
            this.setOnPrintTickLabel((Function2<? super Integer, ? super Float, ? extends CharSequence>)((Function2)new Function2<Integer, Float, String>(this){
                final /* synthetic */ Speedometer this$0;

                @NotNull
                public final String invoke(int $noName_0, float speed) {
                    String string = "%.1f";
                    Locale locale = this.this$0.getLocale();
                    Object[] objectArray = new Object[]{Float.valueOf(speed)};
                    boolean bl = false;
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
                    return string2;
                }
                {
                    this.this$0 = speedometer;
                    super(2);
                }
            }));
        }
        this.degree = this.startDegree;
        a.recycle();
        this.checkStartAndEndDegree();
    }

    private final void initAttributeValue() {
        this.circleBackPaint.setColor(this.backgroundCircleColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        int defaultSize = (int)this.dpTOpx(250.0f);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000 && heightMode == 0x40000000) {
            n3 = 0;
            n2 = Math.min(w, h);
        } else if (widthMode == 0x40000000) {
            n2 = w;
        } else if (heightMode == 0x40000000) {
            n2 = h;
        } else if (widthMode == 0 && heightMode == 0 || widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            n3 = 0;
            n3 = Math.min(w, h);
            n = 0;
            n2 = Math.min(defaultSize, n3);
        } else if (widthMode == Integer.MIN_VALUE) {
            n3 = 0;
            n2 = Math.min(defaultSize, w);
        } else {
            n3 = 0;
            n2 = Math.min(defaultSize, h);
        }
        int size = n2;
        n3 = this.getSuggestedMinimumWidth();
        n = this.getSuggestedMinimumHeight();
        boolean bl = false;
        n3 = Math.max(n3, n);
        n = 0;
        size = Math.max(size, n3);
        int newW = size / this.speedometerMode.getDivWidth$speedviewlib_release();
        int newH = size / this.speedometerMode.getDivHeight$speedviewlib_release();
        if (this.speedometerMode.isHalf()) {
            if (this.speedometerMode.getDivWidth$speedviewlib_release() == 2) {
                newW += this.cutPadding;
            } else {
                newH += this.cutPadding;
            }
        }
        this.setMeasuredDimension(newW, newH);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.indicator.updateIndicator();
        this.updateTranslated();
    }

    private final void checkStartAndEndDegree() {
        boolean bl = this.startDegree >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "StartDegree can't be Negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.endDegree >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "EndDegree can't be Negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.startDegree < this.endDegree;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "EndDegree must be bigger than StartDegree !";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.endDegree - this.startDegree <= 360;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "(EndDegree - StartDegree) must be smaller than 360 !";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.startDegree >= this.speedometerMode.getMinDegree$speedviewlib_release();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl8 = false;
            String string = "StartDegree must be bigger than " + this.speedometerMode.getMinDegree$speedviewlib_release() + " in " + (Object)((Object)this.speedometerMode) + " Mode !";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.endDegree <= this.speedometerMode.getMaxDegree$speedviewlib_release();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl9 = false;
            String string = "EndDegree must be smaller than " + this.speedometerMode.getMaxDegree$speedviewlib_release() + " in " + (Object)((Object)this.speedometerMode) + " Mode !";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    protected abstract void defaultSpeedometerValues();

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.degree = this.getDegreeAtSpeed(this.getCurrentSpeed());
    }

    /*
     * WARNING - void declaration
     */
    protected final void drawMarks(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.markPath.reset();
        this.markPath.moveTo((float)this.getSize() * 0.5f, this.marksPadding + (float)this.getPadding());
        this.markPath.lineTo((float)this.getSize() * 0.5f, this.marksPadding + this.markHeight + (float)this.getPadding());
        canvas.save();
        canvas.rotate(90.0f + (float)this.getStartDegree(), (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        float everyDegree = (float)(this.getEndDegree() - this.getStartDegree()) / ((float)this.marksNumber + 1.0f);
        int n = 1;
        int n2 = this.marksNumber;
        if (n <= n2) {
            while (true) {
                void i;
                canvas.rotate(everyDegree, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
                canvas.drawPath(this.markPath, this.markPaint);
                if (i == n2) break;
                ++i;
            }
        }
        canvas.restore();
    }

    protected final void drawIndicator(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.isWithIndicatorLight) {
            this.drawIndicatorLight(canvas);
        }
        this.indicator.draw(canvas, this.degree);
    }

    protected final void drawIndicatorLight(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        float MAX_LIGHT_SWEEP = 30.0f;
        float f = this.getPercentSpeed() - this.lastPercentSpeed;
        boolean bl = false;
        float sweep = Math.abs(f) * MAX_LIGHT_SWEEP;
        this.lastPercentSpeed = this.getPercentSpeed();
        if (sweep > MAX_LIGHT_SWEEP) {
            sweep = MAX_LIGHT_SWEEP;
        }
        int[] colors = new int[]{this.indicatorLightColor, 0xFFFFFF};
        SweepGradient lightSweep = new SweepGradient((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, colors, new float[]{0.0f, sweep / 360.0f});
        this.indicatorLightPaint.setShader((Shader)lightSweep);
        this.indicatorLightPaint.setStrokeWidth(this.indicator.getLightBottom() - this.indicator.getTop());
        float risk = this.indicator.getTop() + this.indicatorLightPaint.getStrokeWidth() * 0.5f;
        RectF speedometerRect = new RectF(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
        canvas.save();
        canvas.rotate(this.degree, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        if (this.isSpeedIncrease()) {
            canvas.scale(1.0f, -1.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        }
        canvas.drawArc(speedometerRect, 0.0f, sweep, false, this.indicatorLightPaint);
        canvas.restore();
    }

    protected final void drawNotes(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        for (Note<?> note : this.notes) {
            float f;
            if (note.getPosition() == Note.Position.CenterSpeedometer) {
                note.draw(canvas, (float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f);
                continue;
            }
            switch (Speedometer$WhenMappings.$EnumSwitchMapping$2[note.getPosition().ordinal()]) {
                case 1: {
                    f = this.indicator.getTop();
                    break;
                }
                case 2: {
                    f = (this.indicator.getTop() + this.indicator.getBottom()) * 0.5f;
                    break;
                }
                case 3: {
                    f = this.indicator.getBottom();
                    break;
                }
                case 4: {
                    f = this.getPadding();
                    break;
                }
                case 5: {
                    f = (float)this.getHeightPa() * 0.25f + (float)this.getPadding();
                    break;
                }
                case 6: {
                    f = this.getViewCenterY();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            float y = f;
            canvas.save();
            canvas.rotate(90.0f + this.degree, (float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f);
            canvas.rotate(-(90.0f + this.degree), (float)this.getWidth() * 0.5f, y);
            note.draw(canvas, (float)this.getWidth() * 0.5f, y);
            canvas.restore();
        }
    }

    @Override
    @NotNull
    protected Canvas createBackgroundBitmapCanvas() {
        if (this.getSize() == 0) {
            return new Canvas();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.getSize(), (int)this.getSize(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(size\u2026 Bitmap.Config.ARGB_8888)");
        this.setBackgroundBitmap(bitmap);
        Canvas canvas = new Canvas(this.getBackgroundBitmap());
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f - (float)this.getPadding(), this.circleBackPaint);
        canvas.clipRect(0, 0, this.getSize(), this.getSize());
        return canvas;
    }

    protected final float getDegreeAtSpeed(float speed) {
        return (speed - this.getMinSpeed()) * (float)(this.endDegree - this.startDegree) / (this.getMaxSpeed() - this.getMinSpeed()) + (float)this.startDegree;
    }

    protected final float getSpeedAtDegree(float degree) {
        return (degree - (float)this.startDegree) * (this.getMaxSpeed() - this.getMinSpeed()) / (float)(this.endDegree - this.startDegree) + this.getMinSpeed();
    }

    protected final int getStartDegree() {
        return this.startDegree;
    }

    public final void setStartDegree(int startDegree) {
        this.setStartEndDegree(startDegree, this.endDegree);
    }

    protected final int getEndDegree() {
        return this.endDegree;
    }

    public final void setEndDegree(int endDegree) {
        this.setStartEndDegree(this.startDegree, endDegree);
    }

    public final void setStartEndDegree(int startDegree, int endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
        this.checkStartAndEndDegree();
        this.cancelSpeedAnimator();
        this.degree = this.getDegreeAtSpeed(this.getSpeed());
        if (this.isAttachedToWindow()) {
            this.invalidateGauge();
            this.tremble();
        }
    }

    public final void addNote(@NotNull Note<?> note, long showTimeMillisecond) {
        Intrinsics.checkParameterIsNotNull(note, (String)"note");
        note.build(this.getWidth());
        this.notes.add(note);
        if (showTimeMillisecond == (long)-1) {
            return;
        }
        this.postDelayed(new Runnable(this, note){
            final /* synthetic */ Speedometer this$0;
            final /* synthetic */ Note $note;

            public final void run() {
                if (this.this$0.isAttachedToWindow()) {
                    Speedometer.access$getNotes$p(this.this$0).remove(this.$note);
                    this.this$0.postInvalidate();
                }
            }
            {
                this.this$0 = speedometer;
                this.$note = note;
            }
        }, showTimeMillisecond);
        this.invalidate();
    }

    public static /* synthetic */ void addNote$default(Speedometer speedometer, Note note, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addNote");
        }
        if ((n & 2) != 0) {
            l = 3000L;
        }
        speedometer.addNote(note, l);
    }

    public final void removeAllNotes() {
        this.notes.clear();
        this.invalidate();
    }

    protected final void drawDefMinMaxSpeedPosition(@NotNull Canvas c) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        this.getTextPaint().setTextAlign(this.startDegree % 360 <= 90 ? Paint.Align.RIGHT : (this.startDegree % 360 <= 180 ? Paint.Align.LEFT : (this.startDegree % 360 <= 270 ? Paint.Align.CENTER : Paint.Align.RIGHT)));
        CharSequence tickStart = null;
        if (this.onPrintTickLabel != null) {
            Function2<? super Integer, ? super Float, ? extends CharSequence> function2 = this.onPrintTickLabel;
            if (function2 == null) {
                Intrinsics.throwNpe();
            }
            tickStart = (CharSequence)function2.invoke((Object)0, (Object)Float.valueOf(this.getMinSpeed()));
        }
        if (tickStart == null) {
            String string = "%.0f";
            object2 = this.getLocale();
            object = new Object[]{Float.valueOf(this.getMinSpeed())};
            boolean bl = false;
            String string2 = String.format((Locale)object2, string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            tickStart = string2;
        }
        c.save();
        c.rotate((float)this.startDegree + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        c.rotate(-((float)this.startDegree + 90.0f), (float)this.getSizePa() * 0.5f - this.getTextPaint().getTextSize() + (float)this.getPadding(), this.getTextPaint().getTextSize() + (float)this.getPadding());
        c.drawText(((Object)tickStart).toString(), (float)this.getSizePa() * 0.5f - this.getTextPaint().getTextSize() + (float)this.getPadding(), this.getTextPaint().getTextSize() + (float)this.getPadding(), (Paint)this.getTextPaint());
        c.restore();
        this.getTextPaint().setTextAlign(this.endDegree % 360 <= 90 ? Paint.Align.RIGHT : (this.endDegree % 360 <= 180 ? Paint.Align.LEFT : (this.endDegree % 360 <= 270 ? Paint.Align.CENTER : Paint.Align.RIGHT)));
        CharSequence tickEnd = null;
        if (this.onPrintTickLabel != null) {
            Function2<? super Integer, ? super Float, ? extends CharSequence> function2 = this.onPrintTickLabel;
            if (function2 == null) {
                Intrinsics.throwNpe();
            }
            tickEnd = (CharSequence)function2.invoke((Object)1, (Object)Float.valueOf(this.getMaxSpeed()));
        }
        if (tickEnd == null) {
            object2 = "%.0f";
            object = this.getLocale();
            Object[] objectArray = new Object[]{Float.valueOf(this.getMaxSpeed())};
            boolean bl = false;
            String string = String.format((Locale)object, (String)object2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(locale, this, *args)");
            tickEnd = string;
        }
        c.save();
        c.rotate((float)this.endDegree + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        c.rotate(-((float)this.endDegree + 90.0f), (float)this.getSizePa() * 0.5f + this.getTextPaint().getTextSize() + (float)this.getPadding(), this.getTextPaint().getTextSize() + (float)this.getPadding());
        c.drawText(((Object)tickEnd).toString(), (float)this.getSizePa() * 0.5f + this.getTextPaint().getTextSize() + (float)this.getPadding(), this.getTextPaint().getTextSize() + (float)this.getPadding(), (Paint)this.getTextPaint());
        c.restore();
    }

    /*
     * WARNING - void declaration
     */
    protected final void drawTicks(@NotNull Canvas c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        if (this.ticks.size() == 0) {
            return;
        }
        this.getTextPaint().setTextAlign(Paint.Align.LEFT);
        int range = this.endDegree - this.startDegree;
        Iterable $this$forEachIndexed$iv = this.ticks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void t;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            float f = ((Number)item$iv).floatValue();
            int index = n2;
            boolean bl2 = false;
            float d = (float)this.startDegree + (float)range * t;
            c.save();
            c.rotate(d + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
            if (!this.tickRotation) {
                c.rotate(-(d + 90.0f), (float)this.getSize() * 0.5f, this.initTickPadding + this.getTextPaint().getTextSize() + (float)this.getPadding() + (float)this.tickPadding);
            }
            CharSequence tick = null;
            if (this.onPrintTickLabel != null) {
                Function2<? super Integer, ? super Float, ? extends CharSequence> function2 = this.onPrintTickLabel;
                if (function2 == null) {
                    Intrinsics.throwNpe();
                }
                tick = (CharSequence)function2.invoke((Object)index, (Object)Float.valueOf(this.getSpeedAtDegree(d)));
            }
            if (tick == null) {
                String string = "%.0f";
                Locale locale = this.getLocale();
                Object[] objectArray = new Object[]{Float.valueOf(this.getSpeedAtDegree(d))};
                boolean bl3 = false;
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
                tick = string2;
            }
            c.translate(0.0f, this.initTickPadding + (float)this.getPadding() + (float)this.tickPadding);
            new StaticLayout(tick, this.getTextPaint(), this.getSize(), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false).draw(c);
            c.restore();
        }
    }

    public void setIndicator(@NotNull Indicator.Indicators indicator) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)indicator), (String)"indicator");
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.setIndicator(Indicator.Companion.createIndicator(context, this, indicator));
    }

    private final void checkTicks() {
        for (Float tick : this.ticks) {
            boolean bl = !(tick.floatValue() < 0.0f) && !(tick.floatValue() > 1.0f);
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) continue;
            boolean bl4 = false;
            String string = "ticks must be between [0f, 1f] !!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void updateTranslated() {
        this.setTranslatedDx(this.speedometerMode.isRight() ? (float)(-this.getSize()) * 0.5f + (float)this.cutPadding : 0.0f);
        this.setTranslatedDy(this.speedometerMode.isBottom() ? (float)(-this.getSize()) * 0.5f + (float)this.cutPadding : 0.0f);
    }

    @JvmOverloads
    public Speedometer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.indicator = new NoIndicator(context);
        this.indicatorLightColor = (int)3154073378L;
        this.circleBackPaint = new Paint(1);
        this.indicatorLightPaint = new Paint(1);
        this.markPaint = new Paint(1);
        this.markPath = new Path();
        this.markHeight = this.dpTOpx(9.0f);
        this.backgroundCircleColor = (int)0xFFFFFFFFL;
        this.startDegree = 135;
        this.endDegree = 405;
        this.degree = this.startDegree;
        this.notes = new ArrayList();
        this.speedometerMode = Mode.NORMAL;
        this.ticks = new ArrayList();
        this.tickRotation = true;
        this.tickPadding = (int)(this.getSpeedometerWidth() + this.dpTOpx(3.0f));
        this.init();
        this.initAttributeSet(context, attrs);
        this.initAttributeValue();
    }

    public /* synthetic */ Speedometer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public Speedometer(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public Speedometer(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ ArrayList access$getNotes$p(Speedometer $this) {
        return $this.notes;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0018\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tR\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bj\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lcom/github/anastr/speedviewlib/Speedometer$Mode;", "", "minDegree", "", "maxDegree", "isHalf", "", "divWidth", "divHeight", "(Ljava/lang/String;IIIZII)V", "getDivHeight$speedviewlib_release", "()I", "getDivWidth$speedviewlib_release", "isBottom", "()Z", "isLeft", "isQuarter", "isRight", "isTop", "getMaxDegree$speedviewlib_release", "getMinDegree$speedviewlib_release", "NORMAL", "LEFT", "TOP", "RIGHT", "BOTTOM", "TOP_LEFT", "TOP_RIGHT", "BOTTOM_RIGHT", "BOTTOM_LEFT", "speedviewlib_release"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NORMAL;
        public static final /* enum */ Mode LEFT;
        public static final /* enum */ Mode TOP;
        public static final /* enum */ Mode RIGHT;
        public static final /* enum */ Mode BOTTOM;
        public static final /* enum */ Mode TOP_LEFT;
        public static final /* enum */ Mode TOP_RIGHT;
        public static final /* enum */ Mode BOTTOM_RIGHT;
        public static final /* enum */ Mode BOTTOM_LEFT;
        private static final /* synthetic */ Mode[] $VALUES;
        private final int minDegree;
        private final int maxDegree;
        private final boolean isHalf;
        private final int divWidth;
        private final int divHeight;

        static {
            Mode[] modeArray = new Mode[9];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = NORMAL = new Mode(0, 720, false, 1, 1);
            modeArray[1] = LEFT = new Mode(90, 270, true, 2, 1);
            modeArray[2] = TOP = new Mode(180, 360, true, 1, 2);
            modeArray[3] = RIGHT = new Mode(270, 450, true, 2, 1);
            modeArray[4] = BOTTOM = new Mode(0, 180, true, 1, 2);
            modeArray[5] = TOP_LEFT = new Mode(180, 270, false, 1, 1);
            modeArray[6] = TOP_RIGHT = new Mode(270, 360, false, 1, 1);
            modeArray[7] = BOTTOM_RIGHT = new Mode(0, 90, false, 1, 1);
            modeArray[8] = BOTTOM_LEFT = new Mode(90, 180, false, 1, 1);
            $VALUES = modeArray;
        }

        public final boolean isLeft() {
            return this == LEFT || this == TOP_LEFT || this == BOTTOM_LEFT;
        }

        public final boolean isTop() {
            return this == TOP || this == TOP_LEFT || this == TOP_RIGHT;
        }

        public final boolean isRight() {
            return this == RIGHT || this == TOP_RIGHT || this == BOTTOM_RIGHT;
        }

        public final boolean isBottom() {
            return this == BOTTOM || this == BOTTOM_LEFT || this == BOTTOM_RIGHT;
        }

        public final boolean isQuarter() {
            return !this.isHalf && this != NORMAL;
        }

        public final int getMinDegree$speedviewlib_release() {
            return this.minDegree;
        }

        public final int getMaxDegree$speedviewlib_release() {
            return this.maxDegree;
        }

        public final boolean isHalf() {
            return this.isHalf;
        }

        public final int getDivWidth$speedviewlib_release() {
            return this.divWidth;
        }

        public final int getDivHeight$speedviewlib_release() {
            return this.divHeight;
        }

        private Mode(int minDegree, int maxDegree, boolean isHalf, int divWidth, int divHeight) {
            this.minDegree = minDegree;
            this.maxDegree = maxDegree;
            this.isHalf = isHalf;
            this.divWidth = divWidth;
            this.divHeight = divHeight;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }
}

