/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.Section;
import com.github.anastr.speedviewlib.components.Style;
import com.github.anastr.speedviewlib.components.indicators.NormalIndicator;
import com.github.anastr.speedviewlib.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\u001a\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0014J(\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0014J\b\u0010&\u001a\u00020\u001aH\u0014R$\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/github/anastr/speedviewlib/SpeedView;", "Lcom/github/anastr/speedviewlib/Speedometer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "centerCircleColor", "getCenterCircleColor", "()I", "setCenterCircleColor", "(I)V", "centerCircleRadius", "", "getCenterCircleRadius", "()F", "setCenterCircleRadius", "(F)V", "circlePaint", "Landroid/graphics/Paint;", "speedometerPaint", "speedometerRect", "Landroid/graphics/RectF;", "defaultGaugeValues", "", "defaultSpeedometerValues", "init", "initAttributeSet", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "updateBackgroundBitmap", "speedviewlib_release"})
public class SpeedView
extends Speedometer {
    private final Paint circlePaint;
    private final Paint speedometerPaint;
    private final RectF speedometerRect;
    private float centerCircleRadius;

    public final int getCenterCircleColor() {
        return this.circlePaint.getColor();
    }

    public final void setCenterCircleColor(int centerCircleColor) {
        this.circlePaint.setColor(centerCircleColor);
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    public final float getCenterCircleRadius() {
        return this.centerCircleRadius;
    }

    public final void setCenterCircleRadius(float centerCircleRadius) {
        this.centerCircleRadius = centerCircleRadius;
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    @Override
    protected void defaultGaugeValues() {
    }

    @Override
    protected void defaultSpeedometerValues() {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.setIndicator(new NormalIndicator(context));
        super.setBackgroundCircleColor(0);
        super.setMarksNumber(8);
    }

    private final void init() {
        this.speedometerPaint.setStyle(Paint.Style.STROKE);
        this.circlePaint.setColor((int)0xFF444444L);
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SpeedView, 0, 0);
        this.circlePaint.setColor(a.getColor(R.styleable.SpeedView_sv_centerCircleColor, this.circlePaint.getColor()));
        this.setCenterCircleRadius(a.getDimension(R.styleable.SpeedView_sv_centerCircleRadius, this.centerCircleRadius));
        int styleIndex = a.getInt(R.styleable.SpeedView_sv_sectionStyle, -1);
        if (styleIndex != -1) {
            Iterable $this$forEach$iv = this.getSections();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Section it = (Section)element$iv;
                boolean bl = false;
                it.setStyle(Style.values()[styleIndex]);
            }
        }
        a.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateBackgroundBitmap();
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, this.centerCircleRadius, this.circlePaint);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        Iterable $this$forEach$iv = this.getSections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Section it = (Section)element$iv;
            boolean bl = false;
            float risk = it.getWidth() * 0.5f + (float)this.getPadding() + it.getPadding();
            this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
            this.speedometerPaint.setStrokeWidth(it.getWidth());
            this.speedometerPaint.setColor(it.getColor());
            float startAngle = (float)(this.getEndDegree() - this.getStartDegree()) * it.getStartOffset() + (float)this.getStartDegree();
            float sweepAngle = (float)(this.getEndDegree() - this.getStartDegree()) * it.getEndOffset() - (startAngle - (float)this.getStartDegree());
            if (it.getStyle() == Style.ROUND) {
                float roundAngle = UtilsKt.getRoundAngle(it.getWidth(), this.speedometerRect.width());
                this.speedometerPaint.setStrokeCap(Paint.Cap.ROUND);
                c.drawArc(this.speedometerRect, startAngle + roundAngle, sweepAngle - roundAngle * 2.0f, false, this.speedometerPaint);
                continue;
            }
            this.speedometerPaint.setStrokeCap(Paint.Cap.BUTT);
            c.drawArc(this.speedometerRect, startAngle, sweepAngle, false, this.speedometerPaint);
        }
        this.drawMarks(c);
        if (this.getTickNumber() > 0) {
            this.drawTicks(c);
        } else {
            this.drawDefMinMaxSpeedPosition(c);
        }
    }

    @JvmOverloads
    public SpeedView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.circlePaint = new Paint(1);
        this.speedometerPaint = new Paint(1);
        this.speedometerRect = new RectF();
        this.centerCircleRadius = this.dpTOpx(20.0f);
        this.init();
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ SpeedView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SpeedView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SpeedView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

