/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.Gauge;
import com.github.anastr.speedviewlib.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001:\u0001\"B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0004J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0016H\u0014J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0014J\b\u0010 \u001a\u00020\u0018H\u0014J\b\u0010!\u001a\u00020\u0018H$R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/anastr/speedviewlib/LinearGauge;", "Lcom/github/anastr/speedviewlib/Gauge;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "foregroundBitmap", "Landroid/graphics/Bitmap;", "orientation", "Lcom/github/anastr/speedviewlib/LinearGauge$Orientation;", "getOrientation", "()Lcom/github/anastr/speedviewlib/LinearGauge$Orientation;", "setOrientation", "(Lcom/github/anastr/speedviewlib/LinearGauge$Orientation;)V", "paint", "Landroid/graphics/Paint;", "rect", "Landroid/graphics/Rect;", "createForegroundBitmapCanvas", "Landroid/graphics/Canvas;", "initAttributeSet", "", "onDraw", "canvas", "onSizeChanged", "w", "h", "oldW", "oldH", "updateBackgroundBitmap", "updateFrontAndBackBitmaps", "Orientation", "speedviewlib_release"})
public abstract class LinearGauge
extends Gauge {
    private final Paint paint;
    private final Rect rect;
    private Bitmap foregroundBitmap;
    @NotNull
    private Orientation orientation;

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(@NotNull Orientation orientation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)orientation), (String)"orientation");
        this.orientation = orientation;
        if (this.isAttachedToWindow()) {
            this.requestLayout();
            this.invalidateGauge();
        }
    }

    protected abstract void updateFrontAndBackBitmaps();

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LinearGauge, 0, 0);
        int orientation = a.getInt(R.styleable.LinearGauge_sv_orientation, -1);
        if (orientation != -1) {
            this.setOrientation(Orientation.values()[orientation]);
        }
        a.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateBackgroundBitmap();
    }

    @Override
    protected void updateBackgroundBitmap() {
        this.updateFrontAndBackBitmaps();
    }

    @NotNull
    protected final Canvas createForegroundBitmapCanvas() {
        if (this.getWidthPa() == 0 || this.getHeightPa() == 0) {
            return new Canvas();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidthPa(), (int)this.getHeightPa(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026 Bitmap.Config.ARGB_8888)");
        this.foregroundBitmap = bitmap;
        return new Canvas(this.foregroundBitmap);
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.orientation == Orientation.HORIZONTAL) {
            this.rect.set(0, 0, (int)((float)this.getWidthPa() * this.getOffsetSpeed()), this.getHeightPa());
        } else {
            this.rect.set(0, this.getHeightPa() - (int)((float)this.getHeightPa() * this.getOffsetSpeed()), this.getWidthPa(), this.getHeightPa());
        }
        canvas.translate((float)this.getPadding(), (float)this.getPadding());
        canvas.drawBitmap(this.foregroundBitmap, this.rect, this.rect, this.paint);
        canvas.translate((float)(-this.getPadding()), (float)(-this.getPadding()));
        this.drawSpeedUnitText(canvas);
    }

    @JvmOverloads
    public LinearGauge(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.paint = new Paint(1);
        this.rect = new Rect();
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
        this.foregroundBitmap = bitmap;
        this.orientation = Orientation.HORIZONTAL;
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ LinearGauge(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public LinearGauge(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public LinearGauge(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/github/anastr/speedviewlib/LinearGauge$Orientation;", "", "(Ljava/lang/String;I)V", "HORIZONTAL", "VERTICAL", "speedviewlib_release"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation HORIZONTAL;
        public static final /* enum */ Orientation VERTICAL;
        private static final /* synthetic */ Orientation[] $VALUES;

        static {
            Orientation[] orientationArray = new Orientation[2];
            Orientation[] orientationArray2 = orientationArray;
            orientationArray[0] = HORIZONTAL = new Orientation();
            orientationArray[1] = VERTICAL = new Orientation();
            $VALUES = orientationArray;
        }

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }
    }
}

