/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Path;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/SpindleIndicator;", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "indicatorPath", "Landroid/graphics/Path;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "degree", "", "getTop", "setWithEffects", "withEffects", "", "updateIndicator", "speedviewlib_release"})
public final class SpindleIndicator
extends Indicator<SpindleIndicator> {
    private final Path indicatorPath;

    @Override
    public float getTop() {
        float f = this.getViewSize() * 0.18f;
        Speedometer speedometer = this.getSpeedometer();
        if (speedometer == null) {
            Intrinsics.throwNpe();
        }
        return f + (float)speedometer.getPadding();
    }

    @Override
    public void draw(@NotNull Canvas canvas, float degree) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.getIndicatorPaint());
        canvas.restore();
    }

    @Override
    public void updateIndicator() {
        this.indicatorPath.reset();
        this.indicatorPath.moveTo(this.getCenterX(), this.getCenterY());
        float f = this.getCenterX() - this.getWidth();
        float f2 = this.getViewSize() * 0.34f;
        Speedometer speedometer = this.getSpeedometer();
        if (speedometer == null) {
            Intrinsics.throwNpe();
        }
        float f3 = f2 + (float)speedometer.getPadding();
        float f4 = this.getCenterX();
        float f5 = this.getViewSize() * 0.18f;
        Speedometer speedometer2 = this.getSpeedometer();
        if (speedometer2 == null) {
            Intrinsics.throwNpe();
        }
        this.indicatorPath.quadTo(f, f3, f4, f5 + (float)speedometer2.getPadding());
        float f6 = this.getCenterX() + this.getWidth();
        float f7 = this.getViewSize() * 0.34f;
        Speedometer speedometer3 = this.getSpeedometer();
        if (speedometer3 == null) {
            Intrinsics.throwNpe();
        }
        this.indicatorPath.quadTo(f6, f7 + (float)speedometer3.getPadding(), this.getCenterX(), this.getCenterY());
        this.getIndicatorPaint().setColor(this.getColor());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects) {
            Speedometer speedometer = this.getSpeedometer();
            if (speedometer == null) {
                Intrinsics.throwNpe();
            }
            if (!speedometer.isInEditMode()) {
                this.getIndicatorPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
                return;
            }
        }
        this.getIndicatorPaint().setMaskFilter((MaskFilter)null);
    }

    public SpindleIndicator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.indicatorPath = new Path();
        this.setWidth(this.dpTOpx(16.0f));
    }
}

