/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev.profiling;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.dev.profiling.ProfilerWindow;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.SceneService;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/dev/profiling/ProfilerService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "cpuProfilerWindow", "Lcom/almasb/fxgl/dev/profiling/ProfilerWindow;", "fpsProfilerWindow", "gcRuns", "", "ramProfilerWindow", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "usedRAM", "", "onExit", "", "onInit", "onUpdate", "tpf", "", "Companion", "fxgl"})
public final class ProfilerService
extends EngineService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private SceneService sceneService;
    private long usedRAM;
    private int gcRuns;
    private ProfilerWindow cpuProfilerWindow;
    private ProfilerWindow fpsProfilerWindow;
    private ProfilerWindow ramProfilerWindow;
    private static final Runtime runtime = Runtime.getRuntime();
    private static final double MB = 1048576.0;

    public void onInit() {
        this.fpsProfilerWindow = new ProfilerWindow(300.0, 100.0, "FPS");
        Object[] objectArray = this.fpsProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fpsProfilerWindow");
            throw null;
        }
        objectArray.setNumYTicks(2);
        objectArray = this.fpsProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fpsProfilerWindow");
            throw null;
        }
        objectArray.setPreferredMaxValue(60.0);
        this.cpuProfilerWindow = new ProfilerWindow(300.0, 100.0, "CPU (ms)");
        objectArray = this.cpuProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cpuProfilerWindow");
            throw null;
        }
        objectArray.setNumYTicks(5);
        objectArray = this.cpuProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cpuProfilerWindow");
            throw null;
        }
        objectArray.setPreferredMaxValue(17.0);
        objectArray = this.cpuProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cpuProfilerWindow");
            throw null;
        }
        objectArray.relocate(300.0, 0.0);
        this.ramProfilerWindow = new ProfilerWindow(300.0, 100.0, "RAM (MB)");
        objectArray = this.ramProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ramProfilerWindow");
            throw null;
        }
        objectArray.setNumYTicks(5);
        objectArray = this.ramProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ramProfilerWindow");
            throw null;
        }
        objectArray.setPreferredMaxValue(300.0);
        objectArray = this.ramProfilerWindow;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ramProfilerWindow");
            throw null;
        }
        objectArray.relocate(600.0, 0.0);
        objectArray = this.sceneService;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
            throw null;
        }
        ObservableList observableList = objectArray.getOverlayRoot().getChildren();
        objectArray = new Node[3];
        ProfilerWindow profilerWindow = this.fpsProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fpsProfilerWindow");
            throw null;
        }
        objectArray[0] = (Node)profilerWindow;
        profilerWindow = this.cpuProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cpuProfilerWindow");
            throw null;
        }
        objectArray[1] = (Node)profilerWindow;
        profilerWindow = this.ramProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ramProfilerWindow");
            throw null;
        }
        objectArray[2] = (Node)profilerWindow;
        observableList.addAll(objectArray);
    }

    public void onUpdate(double tpf) {
        Object object;
        ProfilerWindow profilerWindow = this.fpsProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fpsProfilerWindow");
            throw null;
        }
        profilerWindow.update(1.0 / tpf);
        profilerWindow = this.cpuProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cpuProfilerWindow");
            throw null;
        }
        profilerWindow.update((double)FXGL.Companion.cpuNanoTime() / 1000000.0);
        long used = runtime.totalMemory() - runtime.freeMemory();
        if (used < 0L) {
            return;
        }
        if (used < this.usedRAM) {
            object = this;
            int n = object.gcRuns;
            object.gcRuns = n + 1;
        }
        this.usedRAM = used;
        object = this.ramProfilerWindow;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ramProfilerWindow");
            throw null;
        }
        ((ProfilerWindow)((Object)object)).update((double)this.usedRAM / 1048576.0);
    }

    public void onExit() {
        Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
        ProfilerWindow profilerWindow = this.fpsProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fpsProfilerWindow");
            throw null;
        }
        profilerWindow.log();
        profilerWindow = this.cpuProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cpuProfilerWindow");
            throw null;
        }
        profilerWindow.log();
        profilerWindow = this.ramProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ramProfilerWindow");
            throw null;
        }
        profilerWindow.log();
        log.info(Intrinsics.stringPlus((String)"Estimated GC runs: ", (Object)this.gcRuns));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/dev/profiling/ProfilerService$Companion;", "", "()V", "MB", "", "runtime", "Ljava/lang/Runtime;", "kotlin.jvm.PlatformType", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

