/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.particle;

import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.particle.Particle;
import com.almasb.fxgl.particle.ParticleEmitter;
import java.util.Iterator;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/almasb/fxgl/particle/ParticleComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "emitter", "Lcom/almasb/fxgl/particle/ParticleEmitter;", "(Lcom/almasb/fxgl/particle/ParticleEmitter;)V", "getEmitter", "()Lcom/almasb/fxgl/particle/ParticleEmitter;", "isEmitterPaused", "", "()Z", "onFinished", "Ljava/lang/Runnable;", "getOnFinished", "()Ljava/lang/Runnable;", "setOnFinished", "(Ljava/lang/Runnable;)V", "parent", "Lcom/almasb/fxgl/entity/Entity;", "getParent", "()Lcom/almasb/fxgl/entity/Entity;", "particles", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "Lcom/almasb/fxgl/particle/Particle;", "isComponentInjectionRequired", "onRemoved", "", "onUpdate", "tpf", "", "pauseEmitter", "resumeEmitter", "fxgl-entity"})
public class ParticleComponent
extends Component {
    @NotNull
    private final ParticleEmitter emitter;
    @NotNull
    private Runnable onFinished;
    @NotNull
    private final Entity parent;
    @NotNull
    private final UnorderedArray<Particle> particles;

    public ParticleComponent(@NotNull ParticleEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        this.emitter = emitter;
        this.onFinished = (Runnable)EmptyRunnable.INSTANCE;
        this.parent = new Entity();
        this.particles = new UnorderedArray(256);
    }

    @NotNull
    public final ParticleEmitter getEmitter() {
        return this.emitter;
    }

    @NotNull
    public final Runnable getOnFinished() {
        return this.onFinished;
    }

    public final void setOnFinished(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.onFinished = runnable;
    }

    @NotNull
    public final Entity getParent() {
        return this.parent;
    }

    public final boolean isEmitterPaused() {
        return this.emitter.isPaused();
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.parent.getWorld() == null) {
            this.entity.getWorld().addEntity(this.parent);
        }
        this.particles.addAll(this.emitter.emit(this.entity.getX(), this.entity.getY()));
        Iterator iterator = this.particles.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"particles.iterator()");
        Iterator iter = iterator;
        while (iter.hasNext()) {
            Object object;
            Particle p = (Particle)iter.next();
            if (p.update(tpf)) {
                iter.remove();
                ViewComponent viewComponent = this.parent.getViewComponent();
                object = p.getView();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"p.view");
                viewComponent.removeChild((Node)object);
                Pools.free((Object)p);
                continue;
            }
            if (p.getView().getParent() != null) continue;
            object = this.parent.getViewComponent();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent.viewComponent");
            Object object2 = object;
            object = p.getView();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"p.view");
            ViewComponent.addChild$default((ViewComponent)object2, object, false, 2, null);
        }
        if (this.particles.isEmpty() && this.emitter.isFinished()) {
            this.onFinished.run();
        }
    }

    public final void pauseEmitter() {
        this.emitter.pause();
    }

    public final void resumeEmitter() {
        this.emitter.resume();
    }

    @Override
    public void onRemoved() {
        Iterable $this$forEach$iv = (Iterable)this.particles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Particle it = (Particle)element$iv;
            boolean bl = false;
            Pools.free((Object)it);
        }
        this.particles.clear();
        this.parent.removeFromWorld();
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }
}

