/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.components;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.SerializableComponent;
import java.io.Serializable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@CoreComponent
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B-\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010_\u001a\u00020'J\u000e\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020\u0000J\u000e\u0010c\u001a\u00020\b2\u0006\u0010b\u001a\u00020\u0000J\u000e\u0010d\u001a\u00020\b2\u0006\u0010b\u001a\u00020\u0000J\b\u0010e\u001a\u00020fH\u0016J\u000e\u0010g\u001a\u00020a2\u0006\u0010h\u001a\u00020\u0018J\u000e\u0010i\u001a\u00020a2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010j\u001a\u00020a2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010k\u001a\u00020a2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010l\u001a\u00020a2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010m\u001a\u00020a2\u0006\u0010c\u001a\u00020\bJ\u000e\u0010n\u001a\u00020a2\u0006\u0010c\u001a\u00020\bJ\u000e\u0010o\u001a\u00020a2\u0006\u0010c\u001a\u00020\bJ\u000e\u0010p\u001a\u00020a2\u0006\u0010c\u001a\u00020\bJ\u000e\u0010q\u001a\u00020a2\u0006\u0010c\u001a\u00020\bJ\u000e\u0010r\u001a\u00020a2\u0006\u0010c\u001a\u00020\bJ\u0006\u0010s\u001a\u00020'J\u0006\u0010t\u001a\u00020'J\u0006\u0010u\u001a\u00020'J\u0010\u0010v\u001a\u00020a2\u0006\u0010w\u001a\u00020xH\u0016J\u000e\u0010y\u001a\u00020a2\u0006\u0010z\u001a\u00020\bJ\u000e\u0010{\u001a\u00020a2\u0006\u0010|\u001a\u00020\u0004J\u0006\u0010}\u001a\u00020'J\u0006\u0010~\u001a\u00020'J\u0006\u0010\u007f\u001a\u00020'J\u0007\u0010\u0080\u0001\u001a\u00020'J\u0007\u0010\u0081\u0001\u001a\u00020'J\u0007\u0010\u0082\u0001\u001a\u00020'J\u0007\u0010\u0083\u0001\u001a\u00020'J\u0007\u0010\u0084\u0001\u001a\u00020'J\u0007\u0010\u0085\u0001\u001a\u00020'J\u0007\u0010\u0086\u0001\u001a\u000204J\u0007\u0010\u0087\u0001\u001a\u000204J\u0007\u0010\u0088\u0001\u001a\u000204J\u0016\u0010!\u001a\u00020a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010$\u001a\u00020a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\bJ\n\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\u000f\u0010\u008b\u0001\u001a\u00020a2\u0006\u0010|\u001a\u00020\u0004J\u0017\u0010\u008b\u0001\u001a\u00020a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000f\u0010\u008c\u0001\u001a\u00020a2\u0006\u0010|\u001a\u00020\u0018J\u001f\u0010\u008c\u0001\u001a\u00020a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\bJ\u0017\u0010\u008d\u0001\u001a\u00020a2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\bJ\u000f\u0010\u008e\u0001\u001a\u00020a2\u0006\u0010\u0007\u001a\u00020\bJ\u000f\u0010\u008f\u0001\u001a\u00020a2\u0006\u0010\t\u001a\u00020\bJ\u000f\u0010\u0090\u0001\u001a\u00020a2\u0006\u0010\\\u001a\u00020\bJ\t\u0010\u0091\u0001\u001a\u00020aH\u0002J\u0011\u0010\u0092\u0001\u001a\u00020a2\u0006\u0010w\u001a\u00020xH\u0016J\u0007\u0010\u0093\u0001\u001a\u000204J\u0007\u0010\u0094\u0001\u001a\u000204J\u0007\u0010\u0095\u0001\u001a\u000204R$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0005R$\u0010\n\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u0005R$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0011\"\u0004\b!\u0010\u0005R$\u0010\"\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010:\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0011\"\u0004\b<\u0010\u0005R$\u0010=\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010\u001b\"\u0004\b?\u0010%R$\u0010@\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010\u0014\"\u0004\bB\u0010\u0016R$\u0010C\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010\u0014\"\u0004\bE\u0010\u0016R$\u0010F\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010\u0014\"\u0004\bH\u0010\u0016R$\u0010I\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010\u0011\"\u0004\bK\u0010\u0005R$\u0010L\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u001b\"\u0004\bN\u0010%R$\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010\u0014\"\u0004\bP\u0010\u0016R$\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bQ\u0010\u0014\"\u0004\bR\u0010\u0016R$\u0010S\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010\u0014\"\u0004\bU\u0010\u0016R\u001e\u0010V\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u001bR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010\u0014\"\u0004\bY\u0010\u0016R$\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bZ\u0010\u0014\"\u0004\b[\u0010\u0016R$\u0010\\\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b]\u0010\u0014\"\u0004\b^\u0010\u0016\u00a8\u0006\u0096\u0001"}, d2={"Lcom/almasb/fxgl/entity/components/TransformComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "Lcom/almasb/fxgl/entity/component/SerializableComponent;", "p", "Ljavafx/geometry/Point2D;", "(Ljavafx/geometry/Point2D;)V", "()V", "x", "", "y", "angle", "scaleX", "scaleY", "(DDDDD)V", "value", "anchoredPosition", "getAnchoredPosition", "()Ljavafx/geometry/Point2D;", "setAnchoredPosition", "getAngle", "()D", "setAngle", "(D)V", "<set-?>", "Ljavafx/geometry/Point3D;", "direction3D", "getDirection3D", "()Ljavafx/geometry/Point3D;", "localAnchor", "getLocalAnchor", "setLocalAnchor", "position", "getPosition", "setPosition", "position3D", "getPosition3D", "setPosition3D", "(Ljavafx/geometry/Point3D;)V", "propPositionOriginX", "Ljavafx/beans/property/SimpleDoubleProperty;", "propPositionOriginY", "propPositionOriginZ", "propRotationOriginX", "propRotationOriginY", "propRotationOriginZ", "propRotationX", "propRotationY", "propRotationZ", "propScaleOriginX", "propScaleOriginY", "propScaleOriginZ", "propScaleX", "Ljavafx/beans/property/DoubleProperty;", "propScaleY", "propScaleZ", "propX", "propY", "propZ", "rotationOrigin", "getRotationOrigin", "setRotationOrigin", "rotationOrigin3D", "getRotationOrigin3D", "setRotationOrigin3D", "rotationX", "getRotationX", "setRotationX", "rotationY", "getRotationY", "setRotationY", "rotationZ", "getRotationZ", "setRotationZ", "scaleOrigin", "getScaleOrigin", "setScaleOrigin", "scaleOrigin3D", "getScaleOrigin3D", "setScaleOrigin3D", "getScaleX", "setScaleX", "getScaleY", "setScaleY", "scaleZ", "getScaleZ", "setScaleZ", "up3D", "getUp3D", "getX", "setX", "getY", "setY", "z", "getZ", "setZ", "angleProperty", "bindTranslation", "", "other", "distance", "distance3D", "isComponentInjectionRequired", "", "lookAt", "point", "lookDownBy", "lookLeftBy", "lookRightBy", "lookUpBy", "moveBack", "moveBackXZ", "moveForward", "moveForwardXZ", "moveLeft", "moveRight", "positionOriginXProperty", "positionOriginYProperty", "positionOriginZProperty", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "rotateBy", "byAngle", "rotateToVector", "vector", "rotationOriginXProperty", "rotationOriginYProperty", "rotationOriginZProperty", "rotationXProperty", "rotationYProperty", "rotationZProperty", "scaleOriginXProperty", "scaleOriginYProperty", "scaleOriginZProperty", "scaleXProperty", "scaleYProperty", "scaleZProperty", "toString", "", "translate", "translate3D", "translateTowards", "translateX", "translateY", "translateZ", "updateDirection", "write", "xProperty", "yProperty", "zProperty", "fxgl-entity"})
public final class TransformComponent
extends Component
implements SerializableComponent {
    @NotNull
    private final DoubleProperty propX;
    @NotNull
    private final DoubleProperty propY;
    @NotNull
    private final DoubleProperty propZ;
    @NotNull
    private final DoubleProperty propScaleX;
    @NotNull
    private final DoubleProperty propScaleY;
    @NotNull
    private final DoubleProperty propScaleZ;
    @NotNull
    private final SimpleDoubleProperty propPositionOriginX;
    @NotNull
    private final SimpleDoubleProperty propPositionOriginY;
    @NotNull
    private final SimpleDoubleProperty propPositionOriginZ;
    @NotNull
    private final SimpleDoubleProperty propScaleOriginX;
    @NotNull
    private final SimpleDoubleProperty propScaleOriginY;
    @NotNull
    private final SimpleDoubleProperty propScaleOriginZ;
    @NotNull
    private final SimpleDoubleProperty propRotationOriginX;
    @NotNull
    private final SimpleDoubleProperty propRotationOriginY;
    @NotNull
    private final SimpleDoubleProperty propRotationOriginZ;
    @NotNull
    private final SimpleDoubleProperty propRotationX;
    @NotNull
    private final SimpleDoubleProperty propRotationY;
    @NotNull
    private final SimpleDoubleProperty propRotationZ;
    @NotNull
    private Point2D localAnchor;
    @NotNull
    private Point3D direction3D;
    @NotNull
    private Point3D up3D;

    public TransformComponent(double x, double y, double angle, double scaleX, double scaleY) {
        this.propX = (DoubleProperty)new SimpleDoubleProperty(x);
        this.propY = (DoubleProperty)new SimpleDoubleProperty(y);
        this.propZ = (DoubleProperty)new SimpleDoubleProperty(0.0);
        this.propScaleX = (DoubleProperty)new SimpleDoubleProperty(scaleX);
        this.propScaleY = (DoubleProperty)new SimpleDoubleProperty(scaleY);
        this.propScaleZ = (DoubleProperty)new SimpleDoubleProperty(1.0);
        this.propPositionOriginX = new SimpleDoubleProperty(0.0);
        this.propPositionOriginY = new SimpleDoubleProperty(0.0);
        this.propPositionOriginZ = new SimpleDoubleProperty(0.0);
        this.propScaleOriginX = new SimpleDoubleProperty(0.0);
        this.propScaleOriginY = new SimpleDoubleProperty(0.0);
        this.propScaleOriginZ = new SimpleDoubleProperty(0.0);
        this.propRotationOriginX = new SimpleDoubleProperty(0.0);
        this.propRotationOriginY = new SimpleDoubleProperty(0.0);
        this.propRotationOriginZ = new SimpleDoubleProperty(0.0);
        this.propRotationX = new SimpleDoubleProperty(0.0);
        this.propRotationY = new SimpleDoubleProperty(0.0);
        this.propRotationZ = new SimpleDoubleProperty(angle);
        Point2D point2D = Point2D.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"ZERO");
        this.localAnchor = point2D;
        this.direction3D = new Point3D(0.0, 0.0, 1.0);
        this.up3D = new Point3D(0.0, -1.0, 0.0);
    }

    public TransformComponent(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this(p.getX(), p.getY(), 0.0, 1.0, 1.0);
    }

    public TransformComponent() {
        this(0.0, 0.0, 0.0, 1.0, 1.0);
    }

    public final double getX() {
        Double d = this.propX.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propX.value");
        return ((Number)d).doubleValue();
    }

    public final void setX(double value) {
        this.propX.setValue((Number)value);
    }

    public final double getY() {
        Double d = this.propY.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propY.value");
        return ((Number)d).doubleValue();
    }

    public final void setY(double value) {
        this.propY.setValue((Number)value);
    }

    public final double getZ() {
        Double d = this.propZ.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setZ(double value) {
        this.propZ.setValue((Number)value);
    }

    public final double getAngle() {
        Double d = this.propRotationZ.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setAngle(double value) {
        this.propRotationZ.setValue((Number)value);
    }

    public final double getScaleX() {
        Double d = this.propScaleX.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleX.value");
        return ((Number)d).doubleValue();
    }

    public final void setScaleX(double value) {
        this.propScaleX.setValue((Number)value);
    }

    public final double getScaleY() {
        Double d = this.propScaleY.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleY.value");
        return ((Number)d).doubleValue();
    }

    public final void setScaleY(double value) {
        this.propScaleY.setValue((Number)value);
    }

    public final double getScaleZ() {
        Double d = this.propScaleZ.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setScaleZ(double value) {
        this.propScaleZ.setValue((Number)value);
    }

    @NotNull
    public final Point2D getPosition() {
        return new Point2D(this.getX(), this.getY());
    }

    public final void setPosition(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setPosition(value.getX(), value.getY());
    }

    @NotNull
    public final Point3D getPosition3D() {
        return new Point3D(this.getX(), this.getY(), this.getZ());
    }

    public final void setPosition3D(@NotNull Point3D value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setPosition3D(value.getX(), value.getY(), value.getZ());
    }

    public final double getRotationX() {
        Double d = this.propRotationX.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationX.value");
        return ((Number)d).doubleValue();
    }

    public final void setRotationX(double value) {
        this.propRotationX.setValue((Number)value);
    }

    public final double getRotationY() {
        Double d = this.propRotationY.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationY.value");
        return ((Number)d).doubleValue();
    }

    public final void setRotationY(double value) {
        this.propRotationY.setValue((Number)value);
    }

    public final double getRotationZ() {
        Double d = this.propRotationZ.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setRotationZ(double value) {
        this.propRotationZ.setValue((Number)value);
    }

    @NotNull
    public final Point2D getScaleOrigin() {
        Double d = this.propScaleOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleOriginX.value");
        double d2 = ((Number)d).doubleValue();
        d = this.propScaleOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleOriginY.value");
        return new Point2D(d2, ((Number)d).doubleValue());
    }

    public final void setScaleOrigin(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.propScaleOriginX.setValue((Number)value.getX());
        this.propScaleOriginY.setValue((Number)value.getY());
    }

    @NotNull
    public final Point3D getScaleOrigin3D() {
        Double d = this.propScaleOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleOriginX.value");
        double d2 = ((Number)d).doubleValue();
        d = this.propScaleOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleOriginY.value");
        double d3 = ((Number)d).doubleValue();
        d = this.propScaleOriginZ.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propScaleOriginZ.value");
        return new Point3D(d2, d3, ((Number)d).doubleValue());
    }

    public final void setScaleOrigin3D(@NotNull Point3D value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.propScaleOriginX.setValue((Number)value.getX());
        this.propScaleOriginY.setValue((Number)value.getY());
        this.propScaleOriginZ.setValue((Number)value.getZ());
    }

    @NotNull
    public final Point2D getRotationOrigin() {
        Double d = this.propRotationOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationOriginX.value");
        double d2 = ((Number)d).doubleValue();
        d = this.propRotationOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationOriginY.value");
        return new Point2D(d2, ((Number)d).doubleValue());
    }

    public final void setRotationOrigin(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.propRotationOriginX.setValue((Number)value.getX());
        this.propRotationOriginY.setValue((Number)value.getY());
    }

    @NotNull
    public final Point3D getRotationOrigin3D() {
        Double d = this.propRotationOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationOriginX.value");
        double d2 = ((Number)d).doubleValue();
        d = this.propRotationOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationOriginY.value");
        double d3 = ((Number)d).doubleValue();
        d = this.propRotationOriginZ.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"propRotationOriginZ.value");
        return new Point3D(d2, d3, ((Number)d).doubleValue());
    }

    public final void setRotationOrigin3D(@NotNull Point3D value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.propRotationOriginX.setValue((Number)value.getX());
        this.propRotationOriginY.setValue((Number)value.getY());
        this.propRotationOriginZ.setValue((Number)value.getZ());
    }

    @NotNull
    public final DoubleProperty xProperty() {
        return this.propX;
    }

    @NotNull
    public final DoubleProperty yProperty() {
        return this.propY;
    }

    @NotNull
    public final DoubleProperty zProperty() {
        return this.propZ;
    }

    @NotNull
    public final DoubleProperty scaleXProperty() {
        return this.propScaleX;
    }

    @NotNull
    public final DoubleProperty scaleYProperty() {
        return this.propScaleY;
    }

    @NotNull
    public final DoubleProperty scaleZProperty() {
        return this.propScaleZ;
    }

    @NotNull
    public final SimpleDoubleProperty angleProperty() {
        return this.propRotationZ;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginXProperty() {
        return this.propPositionOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginYProperty() {
        return this.propPositionOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginZProperty() {
        return this.propPositionOriginZ;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginXProperty() {
        return this.propScaleOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginYProperty() {
        return this.propScaleOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginZProperty() {
        return this.propScaleOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginXProperty() {
        return this.propRotationOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginYProperty() {
        return this.propRotationOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginZProperty() {
        return this.propRotationOriginZ;
    }

    @NotNull
    public final SimpleDoubleProperty rotationXProperty() {
        return this.propRotationX;
    }

    @NotNull
    public final SimpleDoubleProperty rotationYProperty() {
        return this.propRotationY;
    }

    @NotNull
    public final SimpleDoubleProperty rotationZProperty() {
        return this.propRotationZ;
    }

    public final void setPosition(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public final void setPosition3D(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public final void translateX(double x) {
        this.setX(this.getX() + x);
    }

    public final void translateY(double y) {
        this.setY(this.getY() + y);
    }

    public final void translateZ(double z) {
        this.setZ(this.getZ() + z);
    }

    public final void translate(double x, double y) {
        this.translateX(x);
        this.translateY(y);
    }

    public final void translate3D(double x, double y, double z) {
        this.translateX(x);
        this.translateY(y);
        this.translateZ(z);
    }

    public final void translate(@NotNull Point2D vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this.translate(vector.getX(), vector.getY());
    }

    public final void translate3D(@NotNull Point3D vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this.translate3D(vector.getX(), vector.getY(), vector.getZ());
    }

    public final void translateTowards(@NotNull Point2D position, double distance) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Point2D point2D = position.subtract(this.getX(), this.getY()).normalize().multiply(distance);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"position.subtract(x, y).\u2026lize().multiply(distance)");
        this.translate(point2D);
    }

    public final double distance(@NotNull TransformComponent other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getPosition().distance(other.getPosition());
    }

    public final double distance3D(@NotNull TransformComponent other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getPosition3D().distance(other.getPosition3D());
    }

    public final void rotateBy(double byAngle) {
        SimpleDoubleProperty simpleDoubleProperty = this.propRotationZ;
        simpleDoubleProperty.setValue((Number)(simpleDoubleProperty.getValue() + byAngle));
    }

    public final void rotateToVector(@NotNull Point2D vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this.propRotationZ.setValue((Number)Math.toDegrees(Math.atan2(vector.getY(), vector.getX())));
    }

    @NotNull
    public final Point2D getLocalAnchor() {
        return this.localAnchor;
    }

    public final void setLocalAnchor(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.localAnchor = point2D;
    }

    @NotNull
    public final Point2D getAnchoredPosition() {
        return new Point2D(this.getX() + this.localAnchor.getX(), this.getY() + this.localAnchor.getY());
    }

    public final void setAnchoredPosition(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setPosition(value.getX() - this.localAnchor.getX(), value.getY() - this.localAnchor.getY());
    }

    @NotNull
    public final Point3D getDirection3D() {
        return this.direction3D;
    }

    @NotNull
    public final Point3D getUp3D() {
        return this.up3D;
    }

    public final void lookUpBy(double angle) {
        SimpleDoubleProperty simpleDoubleProperty = this.propRotationX;
        simpleDoubleProperty.setValue((Number)(simpleDoubleProperty.getValue() + angle));
        this.updateDirection();
    }

    public final void lookDownBy(double angle) {
        SimpleDoubleProperty simpleDoubleProperty = this.propRotationX;
        simpleDoubleProperty.setValue((Number)(simpleDoubleProperty.getValue() - angle));
        this.updateDirection();
    }

    public final void lookLeftBy(double angle) {
        SimpleDoubleProperty simpleDoubleProperty = this.propRotationY;
        simpleDoubleProperty.setValue((Number)(simpleDoubleProperty.getValue() - angle));
        this.updateDirection();
    }

    public final void lookRightBy(double angle) {
        SimpleDoubleProperty simpleDoubleProperty = this.propRotationY;
        simpleDoubleProperty.setValue((Number)(simpleDoubleProperty.getValue() + angle));
        this.updateDirection();
    }

    public final void lookAt(@NotNull Point3D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Point3D directionToLook = point.subtract(this.getX(), this.getY(), this.getZ());
        this.setRotationY((double)90 - Math.toDegrees(Math.atan2(directionToLook.getZ(), directionToLook.getX())));
        double theta = Math.toDegrees(Math.asin(Math.abs(directionToLook.getY()) / directionToLook.magnitude()));
        if (directionToLook.getY() > 0.0) {
            this.setRotationX(-theta);
        } else {
            this.setRotationX(theta);
        }
        this.updateDirection();
    }

    public final void moveForwardXZ(double distance) {
        Point3D vector = this.direction3D.multiply(distance);
        this.translate3D(vector.getX(), 0.0, vector.getZ());
    }

    public final void moveBackXZ(double distance) {
        Point3D vector = this.direction3D.multiply(distance);
        this.translate3D(-vector.getX(), 0.0, -vector.getZ());
    }

    public final void moveForward(double distance) {
        Point3D vector = this.direction3D.multiply(distance);
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"vector");
        this.translate3D(vector);
    }

    public final void moveBack(double distance) {
        Point3D vector = this.direction3D.multiply(-distance);
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"vector");
        this.translate3D(vector);
    }

    public final void moveLeft(double distance) {
        Point3D left = this.up3D.crossProduct(this.direction3D).normalize().multiply(distance);
        this.translateX(left.getX());
        this.translateZ(left.getZ());
    }

    public final void moveRight(double distance) {
        Point3D right = this.direction3D.crossProduct(this.up3D).normalize().multiply(distance);
        this.translateX(right.getX());
        this.translateZ(right.getZ());
    }

    private final void updateDirection() {
        double adjustedRotationY = (double)90 - this.getRotationY();
        Point3D point3D = new Point3D(FXGLMath.cosDeg((double)adjustedRotationY), 0.0, FXGLMath.sinDeg((double)adjustedRotationY)).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)point3D, (String)"Point3D(cosDeg(adjustedR\u2026edRotationY)).normalize()");
        this.direction3D = point3D;
        point3D = new Point3D(this.direction3D.getX(), -FXGLMath.sinDeg((double)this.getRotationX()), this.direction3D.getZ() * FXGLMath.cosDeg((double)this.getRotationX())).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)point3D, (String)"Point3D(direction3D.x, -\u2026g(rotationX)).normalize()");
        this.direction3D = point3D;
    }

    public final void bindTranslation(@NotNull TransformComponent other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.xProperty().bind((ObservableValue)other.xProperty());
        this.yProperty().bind((ObservableValue)other.yProperty());
        this.zProperty().bind((ObservableValue)other.zProperty());
    }

    @Override
    @NotNull
    public String toString() {
        return "Transform(" + this.getX() + ", " + this.getY() + ", " + this.getAngle() + ", " + this.getScaleX() + ", " + this.getScaleY() + ")";
    }

    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        bundle.put("propX", (Serializable)Double.valueOf(this.getX()));
        bundle.put("propY", (Serializable)Double.valueOf(this.getY()));
        bundle.put("angle", (Serializable)Double.valueOf(this.getAngle()));
        bundle.put("scaleX", (Serializable)Double.valueOf(this.getScaleX()));
        bundle.put("scaleY", (Serializable)Double.valueOf(this.getScaleY()));
        bundle.put("scaleOriginX", (Serializable)Double.valueOf(this.getScaleOrigin().getX()));
        bundle.put("scaleOriginY", (Serializable)Double.valueOf(this.getScaleOrigin().getY()));
        bundle.put("rotationOriginX", (Serializable)Double.valueOf(this.getRotationOrigin().getX()));
        bundle.put("rotationOriginY", (Serializable)Double.valueOf(this.getRotationOrigin().getY()));
    }

    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.setPosition(((Number)bundle.get("propX")).doubleValue(), ((Number)bundle.get("propY")).doubleValue());
        this.setScaleOrigin(new Point2D(((Number)bundle.get("scaleOriginX")).doubleValue(), ((Number)bundle.get("scaleOriginY")).doubleValue()));
        this.setRotationOrigin(new Point2D(((Number)bundle.get("rotationOriginX")).doubleValue(), ((Number)bundle.get("rotationOriginY")).doubleValue()));
        this.setAngle(((Number)bundle.get("angle")).doubleValue());
        this.setScaleX(((Number)bundle.get("scaleX")).doubleValue());
        this.setScaleY(((Number)bundle.get("scaleY")).doubleValue());
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }
}

