/*
 * Decompiled with CFR 0.152.
 */
package alexh.weak;

import alexh.LiteJoiner;
import alexh.weak.AbstractDynamic;
import alexh.weak.ChildAbsence;
import alexh.weak.Converter;
import alexh.weak.Describer;
import alexh.weak.Dynamic;
import alexh.weak.DynamicChild;
import alexh.weak.DynamicChildLogic;
import alexh.weak.ParentAbsence;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

class DynamicList
extends AbstractDynamic<List>
implements Dynamic,
Describer {
    public DynamicList(List inner) {
        super(inner);
    }

    @Override
    public Dynamic get(Object key) {
        if (((List)this.inner).isEmpty()) {
            return new ParentAbsence.Empty<DynamicList>(this, key);
        }
        Integer index = Optional.ofNullable(key).flatMap(k -> Converter.convert(k).maybe().intoInteger()).orElse(null);
        if (index == null) {
            return new ChildAbsence.Missing<DynamicList>(this, key);
        }
        if (index < 0 || index >= ((List)this.inner).size()) {
            return new ChildAbsence.Missing<DynamicList>(this, (Object)index);
        }
        Object val = ((List)this.inner).get(index);
        return val != null ? DynamicChild.from(this, index, val) : new ChildAbsence.Null(this, (Object)index);
    }

    @Override
    public Stream<Dynamic> children() {
        return IntStream.range(0, ((List)this.inner).size()).mapToObj(this::get);
    }

    @Override
    public String describe() {
        String type = "List";
        switch (((List)this.inner).size()) {
            case 0: {
                return "Empty-List";
            }
            case 1: {
                return "List[0]";
            }
            case 2: {
                return "List[0, 1]";
            }
        }
        return String.format("%s[0..%d]", "List", ((List)this.inner).size() - 1);
    }

    @Override
    protected Object keyLiteral() {
        return "root";
    }

    public String toString() {
        return this.keyLiteral() + ":" + this.describe();
    }

    static class Child
    extends DynamicList
    implements DynamicChild {
        private final Dynamic parent;
        private final Object key;

        Child(Dynamic parent, Object key, List inner) {
            super(inner);
            this.parent = parent;
            this.key = key;
        }

        @Override
        public Dynamic parent() {
            return this.parent;
        }

        @Override
        public Object keyLiteral() {
            return this.key;
        }

        @Override
        public String toString() {
            return LiteJoiner.on("->").join(DynamicChildLogic.using(this).getAscendingKeyChainWithRoot()) + ":" + this.describe();
        }
    }
}

