/*
 * Decompiled with CFR 0.152.
 */
package alexh.weak;

import alexh.weak.BreadthChildIterator;
import alexh.weak.DynamicCollection;
import alexh.weak.DynamicList;
import alexh.weak.DynamicMap;
import alexh.weak.DynamicNothing;
import alexh.weak.DynamicSomething;
import alexh.weak.Weak;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Dynamic
extends Weak<Dynamic> {
    public static final String ROOT_KEY = "root";

    public static Dynamic from(Object val) {
        if (val == null) {
            return DynamicNothing.INSTANCE;
        }
        if (val instanceof Dynamic) {
            return (Dynamic)val;
        }
        if (val instanceof Map) {
            return new DynamicMap((Map)val);
        }
        if (val instanceof List) {
            return new DynamicList((List)val);
        }
        if (val instanceof Collection) {
            return new DynamicCollection((Collection)val);
        }
        return new DynamicSomething(val);
    }

    public Dynamic get(Object var1);

    public Stream<Dynamic> children();

    default public Dynamic get(String keyPath, String separator) {
        Dynamic result = this;
        for (String part : keyPath.split(Pattern.quote(separator))) {
            result = result.get(part);
        }
        return result;
    }

    default public Dynamic dget(String dotSeparatedPath) {
        return this.get(dotSeparatedPath, ".");
    }

    public Weak<?> key();

    default public Stream<Dynamic> allChildren() {
        return this.allChildrenDepthFirst();
    }

    default public Stream<Dynamic> allChildrenDepthFirst() {
        return this.children().flatMap(child -> Stream.concat(Stream.of(child), child.allChildrenDepthFirst()));
    }

    default public Stream<Dynamic> allChildrenBreadthFirst() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new BreadthChildIterator(this), 16), false);
    }

    @Override
    default public <T> T as(Class<T> type) {
        try {
            return type.cast(this.asObject());
        }
        catch (ClassCastException ex) {
            throw new ClassCastException(String.format("'root' miscast: %s. Avoid by checking `if (aDynamic.is(%s.class)) ...` or using `aDynamic.maybe().as(%<s.class)`", ex.getMessage(), type.getSimpleName()));
        }
    }
}

