/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.mozilla.universalchardet.UnicodeBOMInputStream;
import org.mozilla.universalchardet.UniversalDetector;

public final class ReaderFactory {
    private ReaderFactory() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static BufferedReader createBufferedReader(File file, Charset defaultCharset) throws IOException {
        if (defaultCharset == null) {
            throw new NullPointerException("defaultCharset must be not null");
        }
        Charset cs = defaultCharset;
        String detectedEncoding = UniversalDetector.detectCharset(file);
        if (detectedEncoding != null) {
            cs = Charset.forName(detectedEncoding);
        }
        if (!cs.toString().contains("UTF")) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), cs));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new UnicodeBOMInputStream(new BufferedInputStream(new FileInputStream(file))), cs));
    }

    public static BufferedReader createBufferedReader(File file) throws IOException {
        return ReaderFactory.createBufferedReader(file, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedReader createBufferedReader(byte[] data, Charset defaultCharset) throws IOException {
        Charset cs = defaultCharset;
        if (cs == null) {
            throw new NullPointerException("defaultCharset must be not null");
        }
        String detectedEncoding = null;
        try (ByteArrayInputStream is = null;){
            is = new ByteArrayInputStream(data);
            detectedEncoding = UniversalDetector.detectCharset(is);
        }
        if (detectedEncoding != null) {
            cs = Charset.forName(detectedEncoding);
        }
        return new BufferedReader(new InputStreamReader((InputStream)new UnicodeBOMInputStream(new ByteArrayInputStream(new String(data, cs).getBytes(cs))), cs));
    }

    public static BufferedReader createBufferedReader(byte[] data) throws IOException {
        return ReaderFactory.createBufferedReader(data, Charset.defaultCharset());
    }

    @Deprecated
    public static Reader createReaderFromFile(File file, Charset defaultCharset) throws IOException {
        return ReaderFactory.createBufferedReader(file, defaultCharset);
    }

    @Deprecated
    public static Reader createReaderFromFile(File file) throws IOException {
        return ReaderFactory.createReaderFromFile(file, Charset.defaultCharset());
    }
}

