/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import hu.akarnokd.rxjava.interop.RxJavaInterop;
import io.reactivex.Scheduler;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.SchedulerLifecycle;

final class SchedulerV2ToSchedulerV1
extends Scheduler
implements SchedulerLifecycle {
    final io.reactivex.Scheduler source;

    SchedulerV2ToSchedulerV1(io.reactivex.Scheduler source) {
        this.source = source;
    }

    public long now() {
        return this.source.now(TimeUnit.MILLISECONDS);
    }

    public void start() {
        this.source.start();
    }

    public void shutdown() {
        this.source.shutdown();
    }

    public Scheduler.Worker createWorker() {
        return new WorkerV2ToWorkerV1(this.source.createWorker());
    }

    static final class Action0V1ToRunnable
    implements Runnable {
        final Action0 source;

        Action0V1ToRunnable(Action0 source) {
            ObjectHelper.requireNonNull((Object)source, (String)"Source 1.x Action0 is null");
            this.source = source;
        }

        @Override
        public void run() {
            this.source.call();
        }
    }

    static final class WorkerV2ToWorkerV1
    extends Scheduler.Worker {
        final Scheduler.Worker v2Worker;

        WorkerV2ToWorkerV1(Scheduler.Worker v2Worker) {
            this.v2Worker = v2Worker;
        }

        public Subscription schedule(Action0 action) {
            Action0V1ToRunnable runnable = new Action0V1ToRunnable(action);
            return RxJavaInterop.toV1Subscription(this.v2Worker.schedule((Runnable)runnable));
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            Action0V1ToRunnable runnable = new Action0V1ToRunnable(action);
            return RxJavaInterop.toV1Subscription(this.v2Worker.schedule((Runnable)runnable, delayTime, unit));
        }

        public Subscription schedulePeriodically(Action0 action, long initialDelay, long period, TimeUnit unit) {
            Action0V1ToRunnable runnable = new Action0V1ToRunnable(action);
            return RxJavaInterop.toV1Subscription(this.v2Worker.schedulePeriodically((Runnable)runnable, initialDelay, period, unit));
        }

        public long now() {
            return this.v2Worker.now(TimeUnit.MILLISECONDS);
        }

        public void unsubscribe() {
            this.v2Worker.dispose();
        }

        public boolean isUnsubscribed() {
            return this.v2Worker.isDisposed();
        }
    }
}

