/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;

final class CompletableV1ToMaybeV2<T>
extends Maybe<T> {
    final Completable source;

    CompletableV1ToMaybeV2(Completable source) {
        this.source = source;
    }

    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new SourceCompletableSubscriber<T>(observer));
    }

    static final class SourceCompletableSubscriber<T>
    implements CompletableSubscriber,
    Disposable {
        final MaybeObserver<? super T> observer;
        Subscription s;

        SourceCompletableSubscriber(MaybeObserver<? super T> observer) {
            this.observer = observer;
        }

        public void onSubscribe(Subscription d) {
            this.s = d;
            this.observer.onSubscribe((Disposable)this);
        }

        public void onCompleted() {
            this.observer.onComplete();
        }

        public void onError(Throwable error) {
            this.observer.onError(error);
        }

        public void dispose() {
            this.s.unsubscribe();
        }

        public boolean isDisposed() {
            return this.s.isUnsubscribed();
        }
    }
}

