/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.easyxls.bean;

import com.github.abel533.easyxls.bean.Column;
import com.github.abel533.easyxls.bean.Columns;
import com.github.abel533.easyxls.bean.Field;
import com.github.abel533.easyxls.common.FieldUtil;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="excel")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExcelConfig {
    private Boolean cache;
    private String sheet;
    @XmlElement(name="class")
    private String clazz;
    private int sheetNum;
    private int startRow;
    private int maxRow = -1;
    private Boolean header = Boolean.TRUE;
    @XmlElement(name="columns")
    private Columns columns;

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public int getSheetNum() {
        return this.sheetNum;
    }

    public void setSheetNum(int sheetNum) {
        this.sheetNum = sheetNum;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getMaxRow() {
        return this.maxRow;
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getSheet() {
        return this.sheet;
    }

    public void setSheet(String sheet) {
        this.sheet = sheet;
    }

    public Columns getColumns() {
        return this.columns;
    }

    public void setColumns(Columns columns) {
        this.columns = columns;
    }

    public Column getColumn(int index) {
        return this.getColumns().getColumns().get(index);
    }

    public Boolean getHeader() {
        return this.header;
    }

    public void setHeader(Boolean header) {
        this.header = header;
    }

    public String[] getHeaders() {
        String[] headers = new String[this.columns.getColumns().size()];
        Column column = null;
        for (int i = 0; i < this.columns.getColumns().size(); ++i) {
            column = this.columns.getColumns().get(i);
            headers[i] = column.getHeader() != null && !column.getHeader().equals("") ? this.columns.getColumns().get(i).getHeader() : column.getName();
        }
        return headers;
    }

    public String[] getNames() {
        String[] headers = new String[this.columns.getColumns().size()];
        for (int i = 0; i < this.columns.getColumns().size(); ++i) {
            headers[i] = this.columns.getColumns().get(i).getName();
        }
        return headers;
    }

    public String[] getTypes() {
        String[] types = new String[this.columns.getColumns().size()];
        for (int i = 0; i < this.columns.getColumns().size(); ++i) {
            types[i] = this.columns.getColumns().get(i).getType();
        }
        return types;
    }

    public Field getKey() {
        String keyName = null;
        for (int i = 0; i < this.columns.getColumns().size(); ++i) {
            if (!this.columns.getColumns().get(i).getKey().booleanValue()) continue;
            keyName = this.columns.getColumns().get(i).getName();
            break;
        }
        if (keyName != null && !keyName.equals("")) {
            try {
                Field field = FieldUtil.getField(Class.forName(this.clazz), keyName);
                return field;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static class Builder {
        private ExcelConfig excel;
        private Class<?> clazz;
        private String key;
        private String separater = ",";

        public Builder(Class<?> clazz) {
            this.clazz = clazz;
            this.excel = new ExcelConfig();
            this.excel.sheetNum = 0;
            this.excel.startRow = 0;
            this.excel.clazz = clazz.getCanonicalName();
            Columns columns = new Columns();
            columns.setColumns(new ArrayList<Column>());
            this.excel.columns = columns;
        }

        public Builder sheetName(String sheetName) {
            this.excel.sheet = sheetName;
            return this;
        }

        public Builder sheetNum(int sheetNum) {
            this.excel.sheetNum = sheetNum;
            return this;
        }

        public Builder startRow(int startRow) {
            this.excel.startRow = startRow;
            return this;
        }

        public Builder maxRow(int maxRow) {
            this.excel.maxRow = maxRow;
            return this;
        }

        public Builder separater(String separater) {
            this.separater = separater;
            return this;
        }

        public Builder header(Boolean header) {
            this.excel.header = header;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            for (Column column : this.excel.columns.getColumns()) {
                if (column.getName() != null && column.getName().equals(key)) {
                    column.setKey(true);
                    continue;
                }
                column.setKey(false);
            }
            return this;
        }

        public Builder addColumn(Column column) {
            if (column.getType() == null || column.getType().equals("")) {
                Field field = FieldUtil.getField(this.clazz, column.getName());
                column.setType(field.getCanonicalName());
            }
            if (this.key != null && this.key.equals(column.getName())) {
                column.setKey(true);
            } else {
                column.setKey(false);
            }
            this.excel.columns.getColumns().add(column);
            return this;
        }

        public Builder addColumn(String ... names) {
            if (names != null && names.length > 0) {
                for (String name : names) {
                    if (name.indexOf(this.separater) > 0) {
                        String[] ns = name.split(this.separater);
                        switch (ns.length) {
                            case 1: {
                                this.addColumn(new Column(ns[0], ns[0]));
                                break;
                            }
                            case 2: {
                                this.addColumn(new Column(ns[0], ns[1]));
                                break;
                            }
                            case 3: {
                                this.addColumn(new Column(ns[0], ns[1], Integer.parseInt(ns[2])));
                                break;
                            }
                            case 4: {
                                this.addColumn(new Column(ns[0], ns[1], (Integer)Integer.parseInt(ns[2]), ns[3]));
                            }
                        }
                        continue;
                    }
                    this.addColumn(new Column(name, name));
                }
            }
            return this;
        }

        public Builder addColumn(String name, String header) {
            return this.addColumn(new Column(name, header));
        }

        public Builder addColumn(String name, String header, Integer width) {
            return this.addColumn(new Column(name, header, width));
        }

        public Builder addColumn(String name, String header, Class<?> type) {
            return this.addColumn(new Column(name, header, type));
        }

        public Builder addColumn(String name, String header, Integer width, Class<?> type) {
            return this.addColumn(new Column(name, header, width, type));
        }

        public ExcelConfig build() {
            return this.excel;
        }
    }
}

