/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.task;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import xdean.jex.extra.collection.Either;
import xdean.jex.extra.function.ActionE0;
import xdean.jex.extra.function.FuncE0;
import xdean.jex.util.lang.ExceptionUtil;

public class TaskUtil {
    public static void async(Runnable task) {
        Observable.just((Object)task).observeOn(Schedulers.newThread()).subscribe(r -> r.run());
    }

    public static void todoAll(Runnable ... tasks) {
        for (Runnable task : tasks) {
            task.run();
        }
    }

    @SafeVarargs
    public static <T> T firstSuccess(FuncE0<T, ?> ... tasks) throws IllegalStateException {
        for (FuncE0<T, ?> task : tasks) {
            Either<T, ?> res = ExceptionUtil.throwToReturn(task);
            if (!res.isLeft()) continue;
            return res.getLeft();
        }
        throw new IllegalStateException("All tasks failed");
    }

    @SafeVarargs
    public static <T> Optional<T> firstNonNull(FuncE0<T, ?> ... tasks) {
        for (FuncE0<T, ?> task : tasks) {
            T res = ExceptionUtil.uncatch(task);
            if (res == null) continue;
            return Optional.of(res);
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T extends Exception> Optional<T> firstFail(ActionE0<T> ... tasks) {
        for (ActionE0<T> task : tasks) {
            try {
                task.call();
            }
            catch (Exception t) {
                return Optional.of(t);
            }
        }
        return Optional.empty();
    }

    public static void andFinal(Runnable task, Runnable then) {
        try {
            task.run();
        }
        finally {
            then.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T andFinal(Supplier<T> task, Consumer<T> then) {
        Object t = null;
        try {
            T t2 = task.get();
            t = t2;
            T t3 = t2;
            return t3;
        }
        finally {
            then.accept(t);
        }
    }
}

