/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.security;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SecurityUtil {
    public static String md5(InputStream input) throws IOException {
        try {
            return SecurityUtil.digest(input, "MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    public static String digest(InputStream input, String algorithm) throws IOException, NoSuchAlgorithmException {
        Stopwatch sw = Stopwatch.createStarted();
        int bufferSize = 262144;
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        try {
            try (DigestInputStream digestInputStream = new DigestInputStream(input, messageDigest);){
                byte[] buffer = new byte[bufferSize];
                while (digestInputStream.read(buffer) > 0) {
                }
                messageDigest = digestInputStream.getMessageDigest();
                byte[] resultByteArray = messageDigest.digest();
                String string = SecurityUtil.byteArrayToHex(resultByteArray);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sw.stop();
        }
    }

    private static String byteArrayToHex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            if (n >= b.length - 1) continue;
            hs = hs + "";
        }
        return hs;
    }
}

