/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import xdean.jex.util.lang.ExceptionUtil;

public class ReflectUtil {
    private static final UnaryOperator<Executable> EXECUTABLE_GET_ROOT;
    private static final Function<Class<?>, Method[]> CLASS_GET_ROOT_METHODS;
    private static final UnaryOperator<Field> FIELD_GET_ROOT;
    private static final Function<Class<?>, Field[]> CLASS_GET_ROOT_FIELDS;

    public static void setModifiers(AccessibleObject ao, int modifier) {
        Arrays.stream(ReflectUtil.getAllFields(ao.getClass())).filter(f -> f.getName().equals("modifiers")).peek(f -> f.setAccessible(true)).forEach(f -> ExceptionUtil.uncheck(() -> f.set(ao, modifier)));
    }

    public static Method getRootMethod(Method m) {
        return ReflectUtil.getRootExecutable(m);
    }

    public static <T extends Executable> T getRootExecutable(T m) {
        return (T)((Executable)EXECUTABLE_GET_ROOT.apply(m));
    }

    public static Method[] getRootMethods(Class<?> clz) {
        return CLASS_GET_ROOT_METHODS.apply(clz);
    }

    public static Field getRootField(Field f) {
        return (Field)FIELD_GET_ROOT.apply(f);
    }

    public static Field[] getRootFields(Class<?> clz) {
        return CLASS_GET_ROOT_FIELDS.apply(clz);
    }

    public static <T, O> O getFieldValue(Class<T> clz, T t, String fieldName) throws NoSuchFieldException {
        Field field = clz.getDeclaredField(fieldName);
        field.setAccessible(true);
        try {
            return (O)field.get(t);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Field[] getAllFields(Class<?> clz, boolean includeStatic) {
        return (Field[])Arrays.stream(ReflectUtil.getAllFields(clz)).filter(f -> includeStatic || !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
    }

    public static Field[] getAllFields(Class<?> clz) {
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            list.addAll(Arrays.asList(clz.getDeclaredFields()));
        } while ((clz = clz.getSuperclass()) != null);
        return list.toArray(new Field[list.size()]);
    }

    public static Method[] getAllMethods(Class<?> clz) {
        HashSet<Method> set = new HashSet<Method>();
        ArrayList classes = new ArrayList();
        classes.add(clz);
        classes.addAll(Arrays.asList(ReflectUtil.getAllSuperClasses(clz)));
        classes.addAll(Arrays.asList(ReflectUtil.getAllInterfaces(clz)));
        for (Class clazz : classes) {
            set.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return set.toArray(new Method[set.size()]);
    }

    public static Class<?>[] getAllSuperClasses(Class<?> clz) {
        ArrayList list = new ArrayList();
        while ((clz = clz.getSuperclass()) != null) {
            list.add(clz);
        }
        return list.toArray(new Class[list.size()]);
    }

    public static Class<?>[] getAllInterfaces(Class<?> clz) {
        HashSet set = new HashSet();
        ReflectUtil.getAllInterfaces(clz, set);
        return set.toArray(new Class[set.size()]);
    }

    private static void getAllInterfaces(Class<?> clz, Set<Class<?>> visited) {
        if (clz.getSuperclass() != null) {
            ReflectUtil.getAllInterfaces(clz.getSuperclass(), visited);
        }
        for (Class<?> c : clz.getInterfaces()) {
            if (!visited.add(c)) continue;
            ReflectUtil.getAllInterfaces(c, visited);
        }
    }

    public static String getCallerClassName() {
        return ReflectUtil.getCaller().getClassName();
    }

    public static StackTraceElement getCaller() {
        return ReflectUtil.getCaller(1, true);
    }

    public static StackTraceElement getCaller(int deep, boolean ignoreSameClass) {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement currentStack = stElements[1];
        int found = deep + 1;
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement nextStack = stElements[i];
            if (nextStack.getClassName().equals(ReflectUtil.class.getName())) continue;
            if (!ignoreSameClass || !currentStack.getClassName().equals(nextStack.getClassName())) {
                currentStack = nextStack;
                --found;
            }
            if (found != 0) continue;
            return currentStack;
        }
        return null;
    }

    static {
        try {
            Method getRootMethod = Executable.class.getDeclaredMethod("getRoot", new Class[0]);
            getRootMethod.setAccessible(true);
            EXECUTABLE_GET_ROOT = m -> ExceptionUtil.uncheck(() -> (Executable)getRootMethod.invoke(m, new Object[0]));
            Method getRootMethods = Class.class.getDeclaredMethod("privateGetPublicMethods", new Class[0]);
            getRootMethods.setAccessible(true);
            CLASS_GET_ROOT_METHODS = c -> ExceptionUtil.uncheck(() -> (Method[])getRootMethods.invoke(c, new Object[0]));
            Field getRootField = Field.class.getDeclaredField("root");
            getRootField.setAccessible(true);
            FIELD_GET_ROOT = f -> ExceptionUtil.uncheck(() -> (Field)getRootField.get(f));
            Method getRootFields = Class.class.getDeclaredMethod("privateGetPublicFields", Set.class);
            getRootFields.setAccessible(true);
            CLASS_GET_ROOT_FIELDS = c -> ExceptionUtil.uncheck(() -> (Field[])getRootFields.invoke(c, new Object[]{null}));
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("ReflectUtil init fail, check your java version.", e);
        }
    }
}

