/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class FinalizeSupport {
    private static final Map<Reference<?>, Runnable> FINALIZE_TASK_MAP;
    private static final ReferenceQueue<Object> QUEUE;

    public static void finalize(Object o, Runnable r) {
        FinalizeSupport.finalize(o, r, Schedulers.io());
    }

    public static void finalize(Object o, Runnable r, Scheduler s) {
        FINALIZE_TASK_MAP.put(new PhantomReference<Object>(o, QUEUE), () -> s.createWorker().schedule(r));
    }

    static {
        ThreadGroup tg;
        FINALIZE_TASK_MAP = new ConcurrentHashMap();
        QUEUE = new ReferenceQueue();
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        FinalizeHandler handler = new FinalizeHandler(tg, "FinalizeSupport");
        handler.setPriority(8);
        handler.setDaemon(true);
        handler.start();
    }

    private static class FinalizeHandler
    extends Thread {
        public FinalizeHandler(ThreadGroup tg, String name) {
            super(tg, name);
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Reference ref = QUEUE.remove();
                    if (ref == null) continue;
                    Optional.ofNullable(FINALIZE_TASK_MAP.remove(ref)).ifPresent(r -> r.run());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

