/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.function.Function;
import xdean.jex.extra.collection.Either;
import xdean.jex.extra.collection.Wrapper;
import xdean.jex.extra.function.ActionE0;
import xdean.jex.extra.function.FuncE0;
import xdean.jex.log.LogFactory;
import xdean.jex.util.function.FunctionAdapter;

public class ExceptionUtil {
    public static <T extends Throwable, R> R throwIt(T t) throws T {
        throw t;
    }

    public static <T extends Throwable, R> R throwAsUncheck(Throwable t) throws T {
        throw t;
    }

    public static void uncheck(ActionE0<?> task) {
        try {
            task.call();
        }
        catch (Exception t) {
            ExceptionUtil.throwAsUncheck(t);
        }
    }

    public static <T> T uncheck(FuncE0<T, ?> task) {
        return FunctionAdapter.supplierToRunnable(task, r -> ExceptionUtil.uncheck(r));
    }

    public static boolean uncatch(ActionE0<?> task) {
        try {
            task.call();
            return true;
        }
        catch (Exception t) {
            LogFactory.from(ExceptionUtil.class).trace("Dont catch", (Throwable)t);
            return false;
        }
    }

    public static <T> T uncatch(FuncE0<T, ?> task) {
        return FunctionAdapter.supplierToRunnable(task, r -> ExceptionUtil.uncatch(r));
    }

    public static <E extends Exception> Optional<E> throwToReturn(ActionE0<E> task) {
        try {
            task.call();
        }
        catch (Exception t) {
            try {
                return Optional.of(t);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("An unexcepted exception thrown.", t);
            }
        }
        return Optional.empty();
    }

    public static <T, E extends Exception> Either<T, E> throwToReturn(FuncE0<T, E> task) {
        Wrapper<Object> w = new Wrapper<Object>(null);
        return Either.rightOrDefault(ExceptionUtil.throwToReturn(() -> w.set(task.call())), w.get());
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        Throwable t = tr;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static <E extends Exception> void wrapException(Function<Exception, E> wrapper, ActionE0<?> task) throws E {
        try {
            task.call();
        }
        catch (Exception e) {
            throw (Exception)wrapper.apply(e);
        }
    }
}

