/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.unit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public enum Length implements xdean.jex.extra.unit.Unit<Length>
{
    FM(0),
    PM(1),
    NM(2),
    UM(3),
    MM(4),
    M(5);

    private int pow1000;

    private Length(int pow1000) {
        this.pow1000 = pow1000;
    }

    public long toFM(long value) {
        return FM.convert(value, this);
    }

    public long toPM(long value) {
        return PM.convert(value, this);
    }

    public long toNM(long value) {
        return NM.convert(value, this);
    }

    public long toUM(long value) {
        return UM.convert(value, this);
    }

    public long toMM(long value) {
        return MM.convert(value, this);
    }

    public long toM(long value) {
        return M.convert(value, this);
    }

    public double toFM(double value) {
        return FM.convert(value, this);
    }

    public double toPM(double value) {
        return PM.convert(value, this);
    }

    public double toNM(double value) {
        return NM.convert(value, this);
    }

    public double toUM(double value) {
        return UM.convert(value, this);
    }

    public double toMM(double value) {
        return MM.convert(value, this);
    }

    public double toM(double value) {
        return M.convert(value, this);
    }

    @Override
    public long multiple(Length fromUnit) {
        long multiple = 1L;
        int delta = fromUnit.pow1000 - this.pow1000;
        if (delta < 0) {
            multiple = -multiple;
            delta = -delta;
        }
        while (delta > 0) {
            multiple *= 1000L;
            --delta;
        }
        return multiple;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE, ElementType.TYPE_USE, ElementType.LOCAL_VARIABLE})
    public static @interface Unit {
        public Length value();
    }
}

