/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.tryto;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import xdean.jex.extra.function.ActionE0;
import xdean.jex.extra.function.FuncE0;
import xdean.jex.extra.tryto.Failure;
import xdean.jex.extra.tryto.Success;
import xdean.jex.log.LogFactory;

public abstract class Try<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Try<T> to(FuncE0<T, Exception> code, ActionE0<Exception> onFinally) {
        try {
            Success<T> success = new Success<T>(code.call());
            return success;
        }
        catch (Exception e) {
            Failure failure = new Failure(e);
            return failure;
        }
        finally {
            if (onFinally != null) {
                try {
                    onFinally.call();
                }
                catch (Exception e) {
                    LogFactory.from(Try.class).trace().log(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static <T> Try<T> to(FuncE0<T, Exception> code) {
        return Try.to(code, null);
    }

    public static Try<Void> to(ActionE0<Exception> code, ActionE0<Exception> onFinally) {
        return Try.to(() -> {
            code.call();
            return null;
        }, onFinally);
    }

    public static Try<Void> to(ActionE0<Exception> code) {
        return Try.to(code, null);
    }

    public static <T> Try<T> of(T value) {
        return new Success<T>(value);
    }

    public static <T extends Exception> Try<T> ofFailure(T value) {
        return new Failure(value);
    }

    public abstract boolean isFailure();

    public abstract boolean isSuccess();

    public T getOrElse(Supplier<T> defaultValue) {
        return this.isSuccess() ? this.get() : defaultValue.get();
    }

    public T getOrElse(T defaultValue) {
        return this.isSuccess() ? this.get() : defaultValue;
    }

    public Try<T> orElse(Supplier<Try<T>> defaultValue) {
        try {
            return this.isSuccess() ? this : defaultValue.get();
        }
        catch (RuntimeException e) {
            return new Failure(e);
        }
    }

    public Try<T> orElse(Try<T> defaultValue) {
        return this.isSuccess() ? this : defaultValue;
    }

    public abstract T get();

    public abstract Try<T> foreach(Consumer<T> var1);

    public abstract Try<T> onException(Consumer<Exception> var1);

    public abstract <U> Try<U> flatMap(Function<T, Try<U>> var1);

    public abstract <U> Try<U> map(Function<T, U> var1);

    public abstract Try<T> filter(Predicate<T> var1);

    public abstract Try<T> recoverWith(Function<Exception, Try<T>> var1);

    public abstract Try<T> recover(Function<Exception, T> var1);

    public Optional<T> toOptional() {
        return this.isSuccess() ? Optional.ofNullable(this.get()) : Optional.empty();
    }

    public abstract Try<Exception> failed();

    public abstract <U> Try<U> transform(Function<T, Try<U>> var1, Function<Exception, Try<U>> var2);
}

