/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx2;

import io.reactivex.Scheduler;
import io.reactivex.internal.schedulers.RxThreadFactory;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import xdean.jex.extra.LazyValue;
import xdean.jex.log.LogFactory;
import xdean.jex.util.lang.FinalizeSupport;

public class RxSchedulers {
    private static final LazyValue<Scheduler> NEW_IO = LazyValue.create(() -> Schedulers.from((Executor)Executors.newCachedThreadPool((ThreadFactory)new RxThreadFactory("RxSchedulers.newIOScheduler"))));

    public static Scheduler newIO() {
        return NEW_IO.get();
    }

    public static Scheduler fixedSize(final int size) {
        return RxSchedulers.autoClose(Executors.newFixedThreadPool(size, new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("FixedSizeScheduler(size=" + size + ")-" + ++this.i);
                t.setPriority(5);
                t.setDaemon(true);
                return t;
            }
        }));
    }

    public static Scheduler forkJoin(final int size) {
        return RxSchedulers.autoClose(new ForkJoinPool(size, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            int i = 0;

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                class FJWT
                extends ForkJoinWorkerThread {
                    protected FJWT(ForkJoinPool pool) {
                        super(pool);
                    }
                }
                FJWT t = new FJWT(pool);
                t.setName("ForkJoinScheduler(parallelism=" + size + ")-" + ++this.i);
                t.setPriority(5);
                t.setDaemon(true);
                return t;
            }
        }, null, true));
    }

    public static Scheduler autoClose(ExecutorService pool) {
        Scheduler scheduler = Schedulers.from((Executor)pool);
        FinalizeSupport.finalize(scheduler, () -> {
            LogFactory.from(RxSchedulers.class).debug("Shutdown the scheduler from: " + pool);
            pool.shutdown();
        });
        return scheduler;
    }
}

