/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.collection.sequence;

import xdean.jex.extra.collection.IntList;
import xdean.jex.extra.collection.sequence.Sequence;

public class IntSequence
implements Sequence<Integer> {
    private final IntList released = IntList.create();
    private final int start;
    private final int step;
    private int next;

    public static IntSequence create(int start, int step) {
        return new IntSequence(start, step);
    }

    private IntSequence(int start, int step) {
        this.start = start;
        this.step = step;
        this.next = start;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Integer next() {
        if (this.released.isEmpty()) {
            int ret = this.next;
            this.next += this.step;
            return ret;
        }
        int ret = this.released.stream().min().getAsInt();
        this.released.remove(ret);
        return ret;
    }

    @Override
    public boolean release(Integer e) {
        int i = e;
        if (i >= this.start && i < this.next && (i - this.start) % this.step == 0) {
            return this.released.add(i);
        }
        return false;
    }
}

