/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IntList
implements RandomAccess,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 5;
    private transient int[] elementData;
    private transient int size;

    public static IntList create() {
        return new IntList();
    }

    public static IntList create(int initCapacity) {
        return new IntList(initCapacity);
    }

    public static IntList create(int[] initArray) {
        return new IntList(initArray);
    }

    public static IntList create(Collection<Integer> list) {
        return IntList.create(list.stream().mapToInt(i -> i).toArray());
    }

    protected IntList() {
        this(5);
    }

    protected IntList(int initCapacity) {
        this.elementData = new int[initCapacity];
    }

    protected IntList(int[] initArray) {
        this.size = initArray.length;
        this.elementData = Arrays.copyOf(initArray, this.size);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int i) {
        return IntStream.of(this.elementData).limit(this.size).anyMatch(a -> a == i);
    }

    public boolean containsAll(int[] is) {
        for (int i : is) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    public Iterator<Integer> iterator() {
        return IntStream.of(this.elementData).limit(this.size).iterator();
    }

    public int[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    public int[] getArray() {
        return this.elementData;
    }

    public boolean add(int i) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = i;
        return true;
    }

    public void add(int index, int element) {
        this.rangeCheckForAdd(index);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    public boolean addAll(int[] is) {
        int numNew = is.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(is, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    public boolean addAll(int index, int[] is) {
        this.rangeCheckForAdd(index);
        boolean modified = false;
        for (int i : is) {
            this.add(index++, i);
            modified = true;
        }
        return modified;
    }

    public boolean remove(int i) {
        for (int index = 0; index < this.size; ++index) {
            if (i != this.elementData[index]) continue;
            this.fastRemove(index);
            --this.size;
            return true;
        }
        return false;
    }

    public int removeIndex(int index) {
        this.rangeCheck(index);
        int oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        --this.size;
        return oldValue;
    }

    public boolean removeAll(int[] is) {
        return this.batchRemove(is, false);
    }

    public boolean retainAll(int[] is) {
        return this.batchRemove(is, true);
    }

    public void clear() {
        this.size = 0;
    }

    public int get(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    public int set(int index, int element) {
        this.rangeCheck(index);
        int oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public int indexOf(int i) {
        for (int idx = 0; idx < this.size; ++idx) {
            if (i != this.elementData[idx]) continue;
            return idx;
        }
        return -1;
    }

    public int lastIndexOf(int i) {
        for (int idx = this.size - 1; idx >= 0; --idx) {
            if (i != this.elementData[idx]) continue;
            return idx;
        }
        return -1;
    }

    public void forEach(IntConsumer action) {
        Objects.requireNonNull(action);
        int[] elementData = this.elementData;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            action.accept(elementData[i]);
        }
    }

    public IntStream stream() {
        return IntStream.of(this.elementData).limit(this.size);
    }

    public List<Integer> boxed() {
        return this.stream().boxed().collect(Collectors.toList());
    }

    public void sort() {
        Arrays.sort(this.elementData, 0, this.size);
    }

    private void fastRemove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
    }

    private boolean batchRemove(int[] is, boolean complement) {
        return this.batchRemove(new IntList(is), complement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(IntList il, boolean complement) {
        int r;
        int[] elementData = this.elementData;
        int w = 0;
        try {
            for (r = 0; r < this.size; ++r) {
                if (il.contains(elementData[r]) != complement) continue;
                elementData[w++] = elementData[r];
            }
        }
        finally {
            if (r != this.size) {
                System.arraycopy(elementData, r, elementData, w, this.size - r);
                w += this.size - r;
            }
            if (w != this.size) {
                this.size = w;
            }
        }
        return true;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            int newCapacity = Math.max(minCapacity, this.elementData.length + (this.elementData.length >> 1));
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            s.writeInt(this.elementData[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.elementData = new int[0];
        s.defaultReadObject();
        this.size = s.readInt();
        if (this.size > 0) {
            this.ensureCapacity(this.size);
            int[] a = this.elementData;
            for (int i = 0; i < this.size; ++i) {
                a[i] = s.readInt();
            }
        }
    }

    public String toString() {
        return "IntList: " + this.stream().mapToObj(Integer::toString).reduce((a, b) -> a + ", " + b).map(s -> "[" + s + "]").orElse("[]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.elementData[i];
        }
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntList other = (IntList)obj;
        if (this.size != other.size) {
            return false;
        }
        int[] a = this.elementData;
        int[] a2 = other.elementData;
        for (int i = 0; i < this.size; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }
}

