/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pf4j.PluginWrapper;
import org.springframework.util.ClassUtils;

public class ScanUtils {
    public static Set<String> scanClassPackageName(String basePackage, Class baseClass) throws IOException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return ScanUtils.scanClassPackageNameOfWindows(basePackage, baseClass);
        }
        return ScanUtils.scanClassPackageNameOfOther(basePackage, baseClass);
    }

    private static Set<String> scanClassPackageNameOfWindows(String basePackage, Class baseClass) throws IOException {
        String classpathRootPath = baseClass.getResource("/").getPath();
        String classpath = classpathRootPath.replace("/", "\\").replaceFirst("\\\\", "");
        basePackage = basePackage.replace(".", File.separator);
        String fullPath = classpath + basePackage;
        return ScanUtils.filterPath(fullPath).map(path -> {
            String pathString = path.toString();
            return pathString.replace(classpath, "").replace("\\", ".").replace(".class", "");
        }).collect(Collectors.toSet());
    }

    private static Set<String> scanClassPackageNameOfOther(String basePackage, Class baseClass) throws IOException {
        String classpath = baseClass.getResource("/").getPath();
        String fullPath = classpath + ClassUtils.classPackageAsResourcePath((Class)baseClass);
        return ScanUtils.filterPath(fullPath).map(path -> {
            String pathString = path.toString();
            pathString = pathString.replace(classpath, "").replace(".class", "");
            return ClassUtils.convertResourcePathToClassName((String)pathString);
        }).collect(Collectors.toSet());
    }

    private static Stream<Path> filterPath(String fullPath) throws IOException {
        return Files.walk(Paths.get(fullPath, new String[0]), new FileVisitOption[0]).filter(Objects::nonNull).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
            String fileName = path.getFileName().toString();
            if (fileName == null) {
                return false;
            }
            return fileName.endsWith(".class");
        });
    }

    public static Set<String> scanClassPackageName(String basePackage, PluginWrapper pluginWrapper) throws IOException {
        String pluginPath = pluginWrapper.getPluginPath().toString();
        HashSet<String> classPackageNames = new HashSet<String>();
        try (JarFile jarFile = new JarFile(pluginPath);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String jarEntryName = entry.getName();
                if (!jarEntryName.contains(".class") || !jarEntryName.replaceAll("/", ".").startsWith(basePackage)) continue;
                String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replace("/", ".");
                classPackageNames.add(className);
            }
        }
        return classPackageNames;
    }
}

