/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.utils.PluginOperatorInfo;
import java.util.HashMap;
import java.util.Map;

public final class GlobalRegistryInfo {
    private static Map<String, PluginOperatorInfo> operatorPluginInfos = new HashMap<String, PluginOperatorInfo>();
    private static Map<String, Object> extensionMap = new HashMap<String, Object>();

    private GlobalRegistryInfo() {
    }

    public static synchronized void addOperatorPluginInfo(String pluginId, PluginOperatorInfo.OperatorType operatorType, boolean isLock) {
        PluginOperatorInfo operatorPluginInfo = operatorPluginInfos.get(pluginId);
        if (operatorPluginInfo == null) {
            operatorPluginInfo = new PluginOperatorInfo();
            operatorPluginInfos.put(pluginId, operatorPluginInfo);
        }
        operatorPluginInfo.setOperatorType(operatorType);
        operatorPluginInfo.setLock(isLock);
    }

    public static synchronized void setOperatorPluginInfo(String pluginId, boolean isLock) {
        PluginOperatorInfo operatorPluginInfo = operatorPluginInfos.get(pluginId);
        if (operatorPluginInfo != null) {
            operatorPluginInfo.setLock(isLock);
        }
    }

    public static synchronized PluginOperatorInfo getPluginInstallNum(String pluginId) {
        return operatorPluginInfos.get(pluginId);
    }

    public static synchronized void addExtension(String key, Object value) {
        extensionMap.put(key, value);
    }

    public static synchronized void removeExtension(String key) {
        extensionMap.remove(key);
    }

    public static synchronized <T> T getExtension(String key) {
        Object o = extensionMap.get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }
}

