/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

public class ClassUtils {
    private ClassUtils() {
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    public static <T> T getReflectionField(Object o, String fieldName) throws IllegalAccessException {
        if (o == null) {
            return null;
        }
        Field templateResolversField = ReflectionUtils.findField(o.getClass(), (String)fieldName);
        return ClassUtils.getReflectionField(templateResolversField, o);
    }

    public static <T> T getReflectionField(Object o, String fieldName, Class<?> fieldClassType) throws IllegalAccessException {
        if (o == null) {
            return null;
        }
        Field templateResolversField = ReflectionUtils.findField(o.getClass(), (String)fieldName, fieldClassType);
        return ClassUtils.getReflectionField(templateResolversField, o);
    }

    public static <T> T getReflectionField(Field field, Object o) throws IllegalAccessException {
        if (field == null) {
            return null;
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Object fieldObject = field.get(o);
        return (T)fieldObject;
    }

    public static Map<String, Object> getAnnotationsUpdater(Object annotation) throws Exception {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        Field field = invocationHandler.getClass().getDeclaredField("memberValues");
        field.setAccessible(true);
        return (Map)field.get(invocationHandler);
    }
}

