/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.pf4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.pf4j.DependencyResolver;
import org.pf4j.PluginDescriptor;
import org.pf4j.VersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SortDependencyResolver
extends DependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortDependencyResolver.class);
    private final List<String> sortInitPluginIds;

    public SortDependencyResolver(List<String> sortInitPluginIds, VersionManager versionManager) {
        super(versionManager);
        this.sortInitPluginIds = sortInitPluginIds;
    }

    public DependencyResolver.Result resolve(List<PluginDescriptor> plugins) {
        DependencyResolver.Result resolve = super.resolve(plugins);
        if (this.sortInitPluginIds == null || this.sortInitPluginIds.isEmpty()) {
            return resolve;
        }
        List sortedPlugins = resolve.getSortedPlugins();
        ArrayList<String> newSortPluginIds = new ArrayList<String>(sortedPlugins.size());
        for (String sortPluginId : this.sortInitPluginIds) {
            Iterator iterator = sortedPlugins.iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                if (!Objects.equals(id, sortPluginId)) continue;
                newSortPluginIds.add(id);
                iterator.remove();
            }
        }
        if (!sortedPlugins.isEmpty()) {
            newSortPluginIds.addAll(sortedPlugins);
        }
        return this.getSortResult(resolve, newSortPluginIds);
    }

    private DependencyResolver.Result getSortResult(DependencyResolver.Result resolve, List<String> newSortPluginIds) {
        try {
            Field sortedPluginsField = ReflectionUtils.findField(DependencyResolver.Result.class, (String)"sortedPlugins");
            List sortedPlugins = null;
            if (sortedPluginsField != null) {
                if (!sortedPluginsField.isAccessible()) {
                    sortedPluginsField.setAccessible(true);
                }
                sortedPlugins = (List)sortedPluginsField.get(resolve);
            }
            if (sortedPlugins == null) {
                return resolve;
            }
            sortedPlugins.clear();
            sortedPlugins.addAll(newSortPluginIds);
            return resolve;
        }
        catch (Exception e) {
            LOGGER.error("Set plugin init sort failure. use default sort init plugin. " + e.getMessage());
            return resolve;
        }
    }
}

