/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.listener;

import com.gitee.starblues.integration.listener.DefaultInitializerListener;
import com.gitee.starblues.integration.listener.PluginInitializerListener;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class PluginInitializerListenerFactory
implements PluginInitializerListener {
    private final List<PluginInitializerListener> pluginInitializerListeners = new ArrayList<PluginInitializerListener>();
    public final ApplicationContext applicationContext;

    public PluginInitializerListenerFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.pluginInitializerListeners.add(new DefaultInitializerListener(applicationContext));
    }

    @Override
    public void before() {
        try {
            for (PluginInitializerListener pluginInitializerListener : this.pluginInitializerListeners) {
                pluginInitializerListener.before();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void complete() {
        try {
            for (PluginInitializerListener pluginInitializerListener : this.pluginInitializerListeners) {
                pluginInitializerListener.complete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void failure(Throwable throwable) {
        try {
            for (PluginInitializerListener pluginInitializerListener : this.pluginInitializerListeners) {
                pluginInitializerListener.failure(throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPluginInitializerListeners(PluginInitializerListener pluginInitializerListener) {
        if (pluginInitializerListener != null) {
            this.pluginInitializerListeners.add(pluginInitializerListener);
        }
    }
}

