/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.application;

import com.gitee.starblues.extension.AbstractExtension;
import com.gitee.starblues.extension.ExtensionFactory;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.application.PluginApplication;
import com.gitee.starblues.integration.listener.PluginListener;
import com.gitee.starblues.integration.listener.PluginListenerFactory;
import com.gitee.starblues.integration.listener.PluginStateListenerFactory;
import java.util.List;
import org.pf4j.PluginStateListener;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public abstract class AbstractPluginApplication
implements PluginApplication {
    protected final PluginListenerFactory listenerFactory = new PluginListenerFactory();
    protected final PluginStateListenerFactory pluginStateListenerFactory = new PluginStateListenerFactory();

    @Override
    public PluginApplication addExtension(AbstractExtension extension) {
        if (extension == null) {
            return this;
        }
        extension.setPluginApplication(this);
        ExtensionFactory.addExtension(extension);
        return this;
    }

    @Override
    public void addListener(PluginListener pluginListener) {
        this.listenerFactory.addPluginListener(pluginListener);
    }

    @Override
    public <T extends PluginListener> void addListener(Class<T> pluginListenerClass) {
        this.listenerFactory.addPluginListener(pluginListenerClass);
    }

    @Override
    public void addListener(List<PluginListener> pluginListeners) {
        if (pluginListeners == null || pluginListeners.isEmpty()) {
            return;
        }
        for (PluginListener pluginListener : pluginListeners) {
            this.listenerFactory.addPluginListener(pluginListener);
        }
    }

    @Override
    public void addPf4jStateListener(PluginStateListener pluginListener) {
        this.pluginStateListenerFactory.addStateListener(pluginListener);
    }

    @Override
    public <T extends PluginStateListener> void addPf4jStateListener(Class<T> pluginListenerClass) {
        this.pluginStateListenerFactory.addStateListener(pluginListenerClass);
    }

    @Override
    public void addPf4jStateListener(List<PluginStateListener> pluginListeners) {
        if (pluginListeners == null || pluginListeners.isEmpty()) {
            return;
        }
        for (PluginStateListener pluginListener : pluginListeners) {
            this.pluginStateListenerFactory.addStateListener(pluginListener);
        }
    }

    protected IntegrationConfiguration getConfiguration(ApplicationContext applicationContext) {
        IntegrationConfiguration configuration = null;
        try {
            configuration = (IntegrationConfiguration)applicationContext.getBean(IntegrationConfiguration.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configuration == null) {
            throw new BeanCreationException("Not Found IntegrationConfiguration, Please define IntegrationConfiguration to Spring Bean.");
        }
        return configuration;
    }
}

