/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.post.bean;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.post.PluginPostProcessor;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.realize.OneselfListener;
import com.gitee.starblues.utils.CommonUtils;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class PluginOneselfStartEventProcessor
implements PluginPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String KEY = "OneselfListeners";

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void registry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
            try {
                GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
                List<OneselfListener> oneselfListeners = SpringBeanUtils.getBeans((ApplicationContext)pluginApplicationContext, OneselfListener.class);
                ArrayList saveOneselfListeners = new ArrayList(oneselfListeners.size());
                oneselfListeners.stream().filter(oneselfListener -> oneselfListener != null).sorted(CommonUtils.orderPriority(oneselfListener -> oneselfListener.order())).forEach(oneselfListener -> {
                    try {
                        oneselfListener.startEvent(basePlugin);
                    }
                    catch (Exception e) {
                        this.log.error("OneselfListener {} execute stopEvent exception. {}", new Object[]{oneselfListener.getClass().getName(), e.getMessage(), e});
                    }
                    finally {
                        saveOneselfListeners.add(oneselfListener);
                    }
                });
                if (saveOneselfListeners.isEmpty()) continue;
                pluginRegistryInfo.addExtension(KEY, saveOneselfListeners);
            }
            catch (Exception e) {
                this.log.error("Plugin '{}' OneselfListener process exception.", (Object)basePlugin.getWrapper().getPluginId(), (Object)e);
            }
        }
    }

    @Override
    public void unRegistry(List<PluginRegistryInfo> pluginRegistryInfos) {
    }
}

