/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.post;

import com.gitee.starblues.extension.ExtensionInitializer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.post.PluginPostProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginControllerPostProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginInvokePostProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginOneselfStartEventProcessor;
import com.gitee.starblues.factory.process.post.bean.PluginWebSocketProcessor;
import com.gitee.starblues.integration.IntegrationConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PluginPostProcessorFactory
implements PluginPostProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final List<PluginPostProcessor> pluginPostProcessors = new ArrayList<PluginPostProcessor>();
    private final ApplicationContext mainApplicationContext;
    private final IntegrationConfiguration integrationConfiguration;

    public PluginPostProcessorFactory(ApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
        this.integrationConfiguration = (IntegrationConfiguration)mainApplicationContext.getBean(IntegrationConfiguration.class);
    }

    @Override
    public void initialize() throws Exception {
        this.pluginPostProcessors.add(new PluginInvokePostProcessor(this.mainApplicationContext));
        this.pluginPostProcessors.add(new PluginControllerPostProcessor(this.mainApplicationContext));
        if (this.integrationConfiguration.enableWebSocket()) {
            this.pluginPostProcessors.add(new PluginWebSocketProcessor(this.mainApplicationContext));
        }
        this.pluginPostProcessors.addAll(ExtensionInitializer.getPostProcessorExtends());
        this.pluginPostProcessors.add(new PluginOneselfStartEventProcessor());
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.initialize();
        }
    }

    @Override
    public void registry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.registry(pluginRegistryInfos);
        }
    }

    @Override
    public void unRegistry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        boolean findException = false;
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            try {
                pluginPostProcessor.unRegistry(pluginRegistryInfos);
            }
            catch (Exception e) {
                findException = true;
                this.LOGGER.error("PluginPostProcessor '{}' unRegistry process exception", (Object)pluginPostProcessor.getClass().getName(), (Object)e);
            }
        }
        if (findException) {
            throw new Exception("UnRegistry plugin failure");
        }
    }
}

