/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.loader.load;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.loader.PluginResourceLoader;
import com.gitee.starblues.factory.process.pipe.loader.ResourceWrapper;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.OrderPriority;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PluginConfigFileLoader
implements PluginResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginConfigFileLoader.class);
    private final String configFilePath;
    private final String fileName;

    public PluginConfigFileLoader(String configFilePath, String fileName) {
        this.configFilePath = configFilePath;
        this.fileName = fileName;
    }

    @Override
    public String key() {
        return null;
    }

    @Override
    public ResourceWrapper load(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        ArrayList<Supplier<SupplierBean>> suppliers = new ArrayList<Supplier<SupplierBean>>();
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        suppliers.add(this.findConfigRoot());
        suppliers.add(this.findPluginRoot(basePlugin));
        suppliers.add(this.findClassPath(pluginRegistryInfo.getPluginClassLoader()));
        for (Supplier supplier : suppliers) {
            SupplierBean supplierBean = (SupplierBean)supplier.get();
            Resource resource = supplierBean.getResource();
            if (!resource.exists()) continue;
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(resource);
            ResourceWrapper resourceWrapper = new ResourceWrapper();
            resourceWrapper.addResources(resources);
            log.info("Load the plugin '{}' config file '{}' from '{}'", new Object[]{basePlugin.getWrapper().getPluginId(), this.fileName, supplierBean.getPath()});
            return resourceWrapper;
        }
        throw new FileNotFoundException("Not found plugin '" + basePlugin.getWrapper().getPluginId() + "' config file : " + this.fileName);
    }

    @Override
    public void unload(PluginRegistryInfo pluginRegistryInfo, ResourceWrapper resourceWrapper) throws Exception {
    }

    @Override
    public OrderPriority order() {
        return OrderPriority.getHighPriority().down(20);
    }

    private Supplier<SupplierBean> findPluginRoot(BasePlugin basePlugin) {
        return () -> {
            Path pluginPath = basePlugin.getWrapper().getPluginPath();
            String rootPath = pluginPath.getParent().toString();
            String configPath = rootPath + File.separatorChar + this.fileName;
            FileSystemResource resource = new FileSystemResource(configPath);
            return new SupplierBean(rootPath, (Resource)resource);
        };
    }

    private Supplier<SupplierBean> findConfigRoot() {
        return () -> {
            String filePath = this.configFilePath + File.separatorChar + this.fileName;
            FileSystemResource resource = new FileSystemResource(filePath);
            return new SupplierBean(this.configFilePath, (Resource)resource);
        };
    }

    private Supplier<SupplierBean> findClassPath(ClassLoader classLoader) {
        return () -> {
            ClassPathResource resource = new ClassPathResource("/" + this.fileName, classLoader);
            return new SupplierBean("classPath", (Resource)resource);
        };
    }

    private class SupplierBean {
        private String path;
        private Resource resource;

        public SupplierBean(String path, Resource resource) {
            this.path = path;
            this.resource = resource;
        }

        public String getPath() {
            return this.path;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

