/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class ResourceWrapper {
    private final List<Resource> resources = new ArrayList<Resource>();
    private final Set<String> classPackageNames = new HashSet<String>();
    private final Map<String, Object> extensions = new HashMap<String, Object>();

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        this.resources.add(resource);
    }

    public void addResources(List<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        this.resources.addAll(resources);
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public void addClassPackageName(String classFullName) {
        if (StringUtils.isEmpty((Object)classFullName)) {
            return;
        }
        this.classPackageNames.add(classFullName);
    }

    public void addClassPackageNames(Set<String> classPackageNames) {
        if (classPackageNames == null || classPackageNames.isEmpty()) {
            return;
        }
        this.classPackageNames.addAll(classPackageNames);
    }

    public Set<String> getClassPackageNames() {
        return Collections.unmodifiableSet(this.classPackageNames);
    }

    public void addExtension(String key, Object value) {
        this.extensions.put(key, value);
    }

    public Object getExtension(String key) {
        return this.extensions.get(key);
    }
}

