/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.loader;

import com.gitee.starblues.factory.PluginRegistryInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class PluginResource
implements Resource {
    private static final Logger log = LoggerFactory.getLogger(PluginResource.class);
    private ClassLoader classLoader;
    private final PluginWrapper pluginWrapper;
    private final long lastModified;
    private final String path;

    public PluginResource(String path, PluginRegistryInfo pluginRegistryInfo) {
        String pathToUse = StringUtils.cleanPath((String)path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        this.classLoader = pluginRegistryInfo.getPluginClassLoader();
        this.pluginWrapper = pluginWrapper;
        this.lastModified = pluginRegistryInfo.getBasePlugin().getBasePluginExtend().getStartTimestamp();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public InputStream getInputStream() throws IOException {
        return this.classLoader.getResourceAsStream(this.path);
    }

    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL((URL)url)) {
            return this.getFile().length();
        }
        if (ResourceUtils.isJarURL((URL)url)) {
            URLConnection con = this.getURL().openConnection();
            return con.getContentLength();
        }
        return 0L;
    }

    public long lastModified() throws IOException {
        return this.lastModified;
    }

    public Resource createRelative(String relativePath) {
        throw new RuntimeException("This method is not supported");
    }

    public String getFilename() {
        return StringUtils.getFilename((String)this.path);
    }

    public String getDescription() {
        return this.pluginWrapper.getDescriptor().getPluginDescription();
    }

    public boolean exists() {
        try {
            URL url = this.getURL();
            if (url == null) {
                return false;
            }
            if (ResourceUtils.isFileURL((URL)url)) {
                return this.getFile().exists();
            }
            if (this.contentLength() >= 0L) {
                return true;
            }
            InputStream is = this.getInputStream();
            is.close();
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isReadable() {
        try {
            URL url = this.getURL();
            if (ResourceUtils.isFileURL((URL)url)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isOpen() {
        return false;
    }

    public File getFile() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isJarURL((URL)url)) {
            URL actualUrl = ResourceUtils.extractArchiveURL((URL)url);
            return ResourceUtils.getFile((URL)actualUrl, (String)"Jar URL");
        }
        return ResourceUtils.getFile((URL)url, (String)this.getDescription());
    }

    public URL getURL() throws IOException {
        return this.classLoader.getResource(this.path);
    }

    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return ResourceUtils.toURI((URL)url);
        }
        catch (URISyntaxException ex) {
            throw new NestedIOException("Invalid URI [" + url + "]", (Throwable)ex);
        }
    }
}

