/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.extract;

import com.gitee.starblues.annotation.Extract;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.SpringBeanRegister;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.extract.ExtractFactory;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class PluginExtractPipeProcessor
implements PluginPipeProcessor {
    private final ApplicationContext mainApplicationContext;
    private final SpringBeanRegister springBeanRegister;
    private final ExtractFactory extractFactory;

    public PluginExtractPipeProcessor(ApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
        this.springBeanRegister = new SpringBeanRegister((GenericApplicationContext)mainApplicationContext);
        this.extractFactory = ExtractFactory.getInstant();
    }

    @Override
    public void initialize() throws Exception {
        this.springBeanRegister.registerSingleton(ExtractFactory.class.getName(), this.extractFactory);
        Map extractMap = this.mainApplicationContext.getBeansWithAnnotation(Extract.class);
        if (!extractMap.isEmpty()) {
            for (Object extract : extractMap.values()) {
                this.extractFactory.addOfMain(extract);
            }
        }
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
        Map extractMap = pluginApplicationContext.getBeansWithAnnotation(Extract.class);
        if (extractMap.isEmpty()) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        for (Object extract : extractMap.values()) {
            this.extractFactory.add(pluginId, extract);
        }
        pluginRegistryInfo.getSpringBeanRegister().registerSingleton(ExtractFactory.class.getName(), this.extractFactory);
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        this.extractFactory.remove(pluginId);
    }
}

