/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.bean;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gitee.starblues.annotation.Caller;
import com.gitee.starblues.annotation.Supplier;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.SpringBeanRegister;
import com.gitee.starblues.factory.process.pipe.bean.PluginBeanRegistrar;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.pf4j.util.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ClassUtils;

public class InvokeBeanRegistrar
implements PluginBeanRegistrar {
    private static final Map<String, Map<String, Object>> PLUGIN_SUPPER_MAP = new ConcurrentHashMap<String, Map<String, Object>>(4);
    public static final String SUPPLIER_KEY = "Invoke_Supplier";

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        this.registrySupper(pluginRegistryInfo);
        this.registryCall(pluginRegistryInfo);
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        PLUGIN_SUPPER_MAP.remove(pluginRegistryInfo.getPluginWrapper().getPluginId());
    }

    private void registrySupper(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        List<Class<?>> supperClasses = pluginRegistryInfo.getGroupClasses("supplier");
        if (supperClasses.isEmpty()) {
            return;
        }
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        HashSet<String> beanNames = new HashSet<String>(supperClasses.size());
        for (Class<?> supperClass : supperClasses) {
            Supplier supplier;
            if (supperClass == null || (supplier = supperClass.getAnnotation(Supplier.class)) == null) continue;
            String beanName = supplier.value();
            if (springBeanRegister.exist(beanName)) {
                String error = MessageFormat.format("Plugin {0} : Bean @Supplier name {1} already exist of {2}", pluginRegistryInfo.getPluginWrapper().getPluginId(), beanName, supperClass.getName());
                throw new Exception(error);
            }
            springBeanRegister.registerOfSpecifyName(beanName, supperClass);
            beanNames.add(beanName);
        }
        pluginRegistryInfo.addExtension(SUPPLIER_KEY, beanNames);
    }

    private void registryCall(PluginRegistryInfo pluginRegistryInfo) {
        List<Class<?>> callerClasses = pluginRegistryInfo.getGroupClasses("caller");
        if (callerClasses == null || callerClasses.isEmpty()) {
            return;
        }
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        for (Class<?> callerClass : callerClasses) {
            Caller caller = callerClass.getAnnotation(Caller.class);
            if (caller == null) continue;
            springBeanRegister.register(callerClass, beanDefinition -> {
                beanDefinition.getPropertyValues().add("callerInterface", (Object)callerClass);
                beanDefinition.getPropertyValues().add("callerAnnotation", (Object)caller);
                beanDefinition.setBeanClass(CallerInterfaceFactory.class);
                beanDefinition.setAutowireMode(2);
            });
        }
    }

    public static void addSupper(String pluginId, String name, Object o) {
        Map superMap = PLUGIN_SUPPER_MAP.computeIfAbsent(pluginId, k -> new HashMap(4));
        superMap.put(name, o);
    }

    public static Object getSupper(String name) {
        for (Map<String, Object> superMap : PLUGIN_SUPPER_MAP.values()) {
            Object o = superMap.get(name);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public static Object getSupper(String pluginId, String name) {
        Map<String, Object> superMap = PLUGIN_SUPPER_MAP.get(pluginId);
        if (superMap == null || superMap.isEmpty()) {
            return null;
        }
        return superMap.get(name);
    }

    private static class ProxyHandler
    implements InvocationHandler {
        private final Caller callerAnnotation;
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private ProxyHandler(Caller callerAnnotation) {
            this.callerAnnotation = callerAnnotation;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object supplierObject = null;
            String pluginId = this.callerAnnotation.pluginId();
            supplierObject = StringUtils.isNullOrEmpty((String)pluginId) ? InvokeBeanRegistrar.getSupper(this.callerAnnotation.value()) : InvokeBeanRegistrar.getSupper(pluginId, this.callerAnnotation.value());
            if (supplierObject == null) {
                if (StringUtils.isNullOrEmpty((String)pluginId)) {
                    throw new Exception("Not found '" + this.callerAnnotation.value() + "' supplier object");
                }
                throw new Exception("Not found '" + this.callerAnnotation.value() + "' supplier object in plugin '" + pluginId + "'");
            }
            Caller.Method callerMethod = method.getAnnotation(Caller.Method.class);
            if (args == null) {
                args = new Object[]{};
            }
            if (callerMethod == null) {
                return this.notAnnotationInvoke(method, supplierObject, args);
            }
            return this.annotationInvoke(method, callerMethod, supplierObject, args);
        }

        private Object annotationInvoke(Method method, Caller.Method callerMethod, Object supplierObject, Object[] args) throws Throwable {
            String callerMethodName = callerMethod.value();
            Class<?> supplierClass = supplierObject.getClass();
            Method[] methods = supplierClass.getMethods();
            Method supplierMethod = null;
            for (Method m : methods) {
                Supplier.Method supplierMethodAnnotation = m.getAnnotation(Supplier.Method.class);
                if (supplierMethodAnnotation == null || !Objects.equals(supplierMethodAnnotation.value(), callerMethodName)) continue;
                supplierMethod = m;
                break;
            }
            if (supplierMethod == null) {
                return this.notAnnotationInvoke(method, supplierObject, args);
            }
            Class<?>[] parameterTypes = supplierMethod.getParameterTypes();
            if (parameterTypes.length != args.length) {
                return this.notAnnotationInvoke(method, supplierObject, args);
            }
            Object[] supplierArgs = new Object[args.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object serializeObject;
                Class<?> parameterType = parameterTypes[i];
                Object arg = args[i];
                if (parameterType == arg.getClass()) {
                    supplierArgs[i] = arg;
                    continue;
                }
                String json = OBJECT_MAPPER.writeValueAsString(arg);
                supplierArgs[i] = serializeObject = OBJECT_MAPPER.readValue(json, parameterType);
            }
            Object invokeReturn = supplierMethod.invoke(supplierObject, supplierArgs);
            return this.getReturnObject(invokeReturn, method);
        }

        private Object notAnnotationInvoke(Method method, Object supplierObject, Object[] args) throws Throwable {
            String name = method.getName();
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            Class<?> supplierClass = supplierObject.getClass();
            Method supplierMethod = supplierClass.getMethod(name, argClasses);
            Object invokeReturn = supplierMethod.invoke(supplierObject, args);
            return this.getReturnObject(invokeReturn, method);
        }

        private Object getReturnObject(Object invokeReturn, Method method) throws Throwable {
            if (invokeReturn == null) {
                return null;
            }
            Class<?> returnType = method.getReturnType();
            if (ClassUtils.isAssignable(invokeReturn.getClass(), returnType)) {
                return invokeReturn;
            }
            String json = OBJECT_MAPPER.writeValueAsString(invokeReturn);
            return OBJECT_MAPPER.readValue(json, OBJECT_MAPPER.getTypeFactory().constructType(method.getGenericReturnType()));
        }
    }

    private static class CallerInterfaceFactory<T>
    implements FactoryBean<T> {
        private Class<T> callerInterface;
        private Caller callerAnnotation;

        private CallerInterfaceFactory() {
        }

        public T getObject() throws Exception {
            ClassLoader classLoader = this.callerInterface.getClassLoader();
            Class[] interfaces = new Class[]{this.callerInterface};
            ProxyHandler proxy = new ProxyHandler(this.callerAnnotation);
            return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)proxy);
        }

        public Class<?> getObjectType() {
            return this.callerInterface;
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<T> getCallerInterface() {
            return this.callerInterface;
        }

        public void setCallerInterface(Class<T> callerInterface) {
            this.callerInterface = callerInterface;
        }

        public Caller getCallerAnnotation() {
            return this.callerAnnotation;
        }

        public void setCallerAnnotation(Caller callerAnnotation) {
            this.callerAnnotation = callerAnnotation;
        }
    }
}

