/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.bean;

import com.gitee.starblues.annotation.ConfigDefinition;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.SpringBeanRegister;
import com.gitee.starblues.factory.process.pipe.bean.PluginBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.bean.configuration.ConfigurationParser;
import com.gitee.starblues.factory.process.pipe.bean.configuration.PluginConfigDefinition;
import com.gitee.starblues.factory.process.pipe.bean.configuration.YamlConfigurationParser;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.realize.ConfigDefinitionTip;
import com.gitee.starblues.utils.ClassUtils;
import com.gitee.starblues.utils.PluginConfigUtils;
import java.lang.reflect.Field;
import java.util.List;
import org.pf4j.util.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class ConfigFileBeanRegistrar
implements PluginBeanRegistrar {
    private final ConfigurationParser configurationParser;
    private final IntegrationConfiguration integrationConfiguration;

    public ConfigFileBeanRegistrar(ApplicationContext mainApplicationContext) {
        this.integrationConfiguration = (IntegrationConfiguration)mainApplicationContext.getBean(IntegrationConfiguration.class);
        this.configurationParser = new YamlConfigurationParser(this.integrationConfiguration);
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        List<Class<?>> configDefinitions = pluginRegistryInfo.getGroupClasses("config_definition");
        if (configDefinitions == null || configDefinitions.isEmpty()) {
            return;
        }
        for (Class<?> aClass : configDefinitions) {
            this.registry(pluginRegistryInfo, aClass);
        }
    }

    private void registry(PluginRegistryInfo pluginRegistryInfo, Class<?> aClass) throws Exception {
        ConfigDefinition configDefinition = aClass.getAnnotation(ConfigDefinition.class);
        if (configDefinition == null) {
            return;
        }
        PluginConfigUtils.FileNamePack fileNamePack = PluginConfigUtils.getConfigFileName(configDefinition, this.integrationConfiguration.environment());
        String fileName = PluginConfigUtils.joinConfigFileName(fileNamePack);
        Object parseObject = null;
        if (!StringUtils.isNullOrEmpty((String)fileName)) {
            PluginConfigDefinition pluginConfigDefinition = new PluginConfigDefinition(fileName, aClass);
            parseObject = this.configurationParser.parse(pluginRegistryInfo, pluginConfigDefinition);
        } else {
            parseObject = aClass.newInstance();
        }
        String name = aClass.getName();
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        this.setConfigDefinitionTip(pluginRegistryInfo, parseObject);
        springBeanRegister.registerSingleton(name, parseObject);
        pluginRegistryInfo.addConfigSingleton(parseObject);
    }

    private void setConfigDefinitionTip(PluginRegistryInfo pluginRegistryInfo, Object parseObject) {
        Class<?> aClass = parseObject.getClass();
        List<Field> fields = ClassUtils.getAllFields(aClass);
        ConfigDefinitionTip configDefinitionTip = new ConfigDefinitionTip(pluginRegistryInfo);
        for (Field field : fields) {
            if (field.getType() != ConfigDefinitionTip.class) continue;
            field.setAccessible(true);
            ReflectionUtils.setField((Field)field, (Object)parseObject, (Object)configDefinitionTip);
        }
    }
}

