/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.interceptor.PluginInterceptorRegister;
import com.gitee.starblues.factory.process.pipe.interceptor.PluginInterceptorRegistry;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.utils.ClassUtils;
import com.gitee.starblues.utils.CommonUtils;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

public class PluginInterceptorsPipeProcessor
implements PluginPipeProcessor {
    private final ApplicationContext mainApplicationContext;
    private final IntegrationConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INTERCEPTORS = "interceptors";
    private AbstractHandlerMapping handlerMapping;

    public PluginInterceptorsPipeProcessor(ApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
        this.configuration = (IntegrationConfiguration)mainApplicationContext.getBean(IntegrationConfiguration.class);
    }

    @Override
    public void initialize() throws Exception {
        this.handlerMapping = SpringBeanUtils.getExistBean(this.mainApplicationContext, AbstractHandlerMapping.class);
        if (this.handlerMapping == null) {
            this.logger.warn("Not found AbstractHandlerMapping, Plugin interceptor can't use");
        }
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        if (this.handlerMapping == null) {
            return;
        }
        GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
        List<PluginInterceptorRegister> interceptorRegisters = SpringBeanUtils.getBeans((ApplicationContext)pluginApplicationContext, PluginInterceptorRegister.class);
        ArrayList<HandlerInterceptor> interceptorsObjects = new ArrayList<HandlerInterceptor>();
        List<HandlerInterceptor> adaptedInterceptors = this.getAdaptedInterceptors();
        if (adaptedInterceptors == null) {
            return;
        }
        String pluginRestPrefix = CommonUtils.getPluginRestPrefix(this.configuration, pluginRegistryInfo.getPluginWrapper().getPluginId());
        for (PluginInterceptorRegister interceptorRegister : interceptorRegisters) {
            PluginInterceptorRegistry interceptorRegistry = new PluginInterceptorRegistry(pluginRestPrefix);
            interceptorRegister.registry(interceptorRegistry);
            List<Object> interceptors = interceptorRegistry.getInterceptors();
            if (interceptors == null || interceptors.isEmpty()) continue;
            for (Object interceptor : interceptors) {
                HandlerInterceptor handlerInterceptor = this.adaptInterceptor(interceptor);
                adaptedInterceptors.add(handlerInterceptor);
                interceptorsObjects.add(handlerInterceptor);
            }
        }
        pluginRegistryInfo.addExtension(INTERCEPTORS, interceptorsObjects);
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        if (this.handlerMapping == null) {
            return;
        }
        List interceptorsObjects = (List)pluginRegistryInfo.getExtension(INTERCEPTORS);
        if (interceptorsObjects == null || interceptorsObjects.isEmpty()) {
            return;
        }
        List<HandlerInterceptor> adaptedInterceptors = this.getAdaptedInterceptors();
        if (adaptedInterceptors == null) {
            return;
        }
        for (HandlerInterceptor interceptor : interceptorsObjects) {
            adaptedInterceptors.remove(interceptor);
        }
    }

    private List<HandlerInterceptor> getAdaptedInterceptors() {
        try {
            return (List)ClassUtils.getReflectionField(this.handlerMapping, "adaptedInterceptors", List.class);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Can't get 'adaptedInterceptors' from AbstractHandlerMapping, so You can't use HandlerInterceptor. {} ", (Object)e.getMessage());
            return null;
        }
    }

    private HandlerInterceptor adaptInterceptor(Object interceptor) {
        if (interceptor instanceof HandlerInterceptor) {
            return (HandlerInterceptor)interceptor;
        }
        if (interceptor instanceof WebRequestInterceptor) {
            return new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)interceptor);
        }
        throw new IllegalArgumentException("Interceptor type not supported: " + interceptor.getClass().getName());
    }
}

