/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.support.GenericApplicationContext;

public class PluginInfoContainers {
    private static final Map<String, GenericApplicationContext> PLUGIN_APPLICATION_CONTEXTS = new ConcurrentHashMap<String, GenericApplicationContext>();

    public static void addPluginApplicationContext(String pluginId, GenericApplicationContext applicationContext) {
        PLUGIN_APPLICATION_CONTEXTS.put(pluginId, applicationContext);
    }

    public static void removePluginApplicationContext(String pluginId) {
        PLUGIN_APPLICATION_CONTEXTS.remove(pluginId);
    }

    public static GenericApplicationContext getPluginApplicationContext(String pluginId) {
        GenericApplicationContext applicationContext = PLUGIN_APPLICATION_CONTEXTS.get(pluginId);
        if (applicationContext == null) {
            return null;
        }
        return applicationContext;
    }

    public static List<GenericApplicationContext> getPluginApplicationContexts() {
        Collection<GenericApplicationContext> values = PLUGIN_APPLICATION_CONTEXTS.values();
        if (values.isEmpty()) {
            return new ArrayList<GenericApplicationContext>();
        }
        return new ArrayList<GenericApplicationContext>(values);
    }
}

