/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory;

import java.text.MessageFormat;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.support.GenericApplicationContext;

public class SpringBeanRegister {
    private static final Logger logger = LoggerFactory.getLogger(SpringBeanRegister.class);
    private final GenericApplicationContext applicationContext;

    public SpringBeanRegister(GenericApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean exist(String name) {
        return this.applicationContext.containsBean(name);
    }

    public String register(Class<?> aClass) {
        return this.register(aClass, null);
    }

    @Deprecated
    public String register(String pluginId, Class<?> aClass) {
        return this.register(pluginId, aClass, null);
    }

    public String register(Class<?> aClass, Consumer<AnnotatedGenericBeanDefinition> consumer) {
        AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(aClass);
        beanDefinition.setBeanClass(aClass);
        AnnotationBeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
        String beanName = beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)this.applicationContext);
        if (this.applicationContext.containsBean(beanName)) {
            String error = MessageFormat.format("Bean name {0} already exist of {1}", beanName, aClass.getName());
            logger.debug(error);
            return beanName;
        }
        if (consumer != null) {
            consumer.accept(beanDefinition);
        }
        this.applicationContext.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return beanName;
    }

    @Deprecated
    public String register(String pluginId, Class<?> aClass, Consumer<AnnotatedGenericBeanDefinition> consumer) {
        return this.register(aClass, consumer);
    }

    public void registerOfSpecifyName(String beanName, Class<?> aClass) {
        this.registerOfSpecifyName(beanName, aClass, null);
    }

    @Deprecated
    public void registerOfSpecifyName(String pluginId, String beanName, Class<?> aClass) {
        this.registerOfSpecifyName(pluginId, beanName, aClass, null);
    }

    public void registerOfSpecifyName(String beanName, Class<?> aClass, Consumer<AnnotatedGenericBeanDefinition> consumer) {
        AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(aClass);
        if (this.applicationContext.containsBean(beanName)) {
            String error = MessageFormat.format("Bean name {0} already exist of {1}", beanName, aClass.getName());
            throw new RuntimeException(error);
        }
        if (consumer != null) {
            consumer.accept(beanDefinition);
        }
        this.applicationContext.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    @Deprecated
    public void registerOfSpecifyName(String pluginId, String beanName, Class<?> aClass, Consumer<AnnotatedGenericBeanDefinition> consumer) {
        this.registerOfSpecifyName(beanName, aClass, consumer);
    }

    public void registerSingleton(String name, Object object) {
        DefaultListableBeanFactory listableBeanFactory = this.applicationContext.getDefaultListableBeanFactory();
        if (!listableBeanFactory.containsSingleton(name)) {
            listableBeanFactory.registerSingleton(name, object);
        }
    }

    public void destroySingleton(String name) {
        DefaultListableBeanFactory listableBeanFactory = this.applicationContext.getDefaultListableBeanFactory();
        if (listableBeanFactory.containsSingleton(name)) {
            listableBeanFactory.destroySingleton(name);
        }
    }

    public void destroySingletons() {
        DefaultListableBeanFactory listableBeanFactory = this.applicationContext.getDefaultListableBeanFactory();
        listableBeanFactory.destroySingletons();
    }

    public void unregister(String pluginId, String beanName) {
        try {
            this.applicationContext.removeBeanDefinition(beanName);
        }
        catch (Exception e) {
            logger.error("Remove plugin '{}' bean {} error. {}", new Object[]{pluginId, beanName, e.getMessage()});
        }
    }
}

